/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood;

import java.util.HashMap;
import java.util.Map;
import moonfather.cookyourfood.Constants;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class FoodResolver {
    private static final Map<Item, RawFoodRank> foodMap = new HashMap<Item, RawFoodRank>();

    public static void AddCustomRawFoodLight(Item item) {
        foodMap.put(item, RawFoodRank.Light);
    }

    public static void AddCustomRawFoodNormal(Item item) {
        foodMap.put(item, RawFoodRank.Normal);
    }

    public static void AddCustomRawFoodSevere(Item item) {
        foodMap.put(item, RawFoodRank.Severe);
    }

    public static void AddOkToEatRaw(Item item) {
        foodMap.put(item, RawFoodRank.OkayToEat);
    }

    public static RawFoodRank Resolve(ItemStack stack, Level world, LivingEntity player) {
        RawFoodRank[] rank = new RawFoodRank[]{foodMap.getOrDefault(stack.getItem(), RawFoodRank.NotMapped)};
        if (!rank[0].equals((Object)RawFoodRank.NotMapped)) {
            return rank[0];
        }
        if (stack.is(Constants.Tags.OK_TO_EAT_RAW)) {
            foodMap.put(stack.getItem(), RawFoodRank.OkayToEat);
            return RawFoodRank.OkayToEat;
        }
        if (stack.is(Constants.Tags.RAW_FOOD_SEVERE)) {
            foodMap.put(stack.getItem(), RawFoodRank.Severe);
            return RawFoodRank.Severe;
        }
        if (stack.is(Constants.Tags.RAW_FOOD_LIGHT)) {
            foodMap.put(stack.getItem(), RawFoodRank.Light);
            return RawFoodRank.Light;
        }
        if (stack.is(Constants.Tags.RAW_FOOD_NORMAL)) {
            foodMap.put(stack.getItem(), RawFoodRank.Normal);
            return RawFoodRank.Normal;
        }
        rank[0] = RawFoodRank.NotACookableFood;
        world.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(stack), world).ifPresent(r -> {
            if (!((CampfireCookingRecipe)r.value()).getResultItem((HolderLookup.Provider)world.registryAccess()).isEmpty() && ((CampfireCookingRecipe)r.value()).getResultItem((HolderLookup.Provider)world.registryAccess()).getFoodProperties(player) != null) {
                rank[0] = RawFoodRank.Normal;
            }
        });
        foodMap.put(stack.getItem(), rank[0]);
        return rank[0];
    }

    public static enum RawFoodRank {
        NotMapped,
        NotACookableFood,
        OkayToEat,
        Light,
        Normal,
        Severe;

    }
}

