/*
 * Decompiled with CFR 0.152.
 */
package moonfather.cookyourfood;

import java.util.Calendar;
import java.util.Optional;
import java.util.Random;
import moonfather.cookyourfood.EffectPools;
import moonfather.cookyourfood.FoodResolver;
import moonfather.cookyourfood.OptionsHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber
public class EventBusHandlers {
    private static final Random random = new Random();

    @SubscribeEvent
    public static void OnFood(ServerStartedEvent event) {
        EffectPools.getNormal();
    }

    @SubscribeEvent
    public static void OnFood(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Item item = event.getItem().getItem();
        if (item.getFoodProperties(event.getItem(), event.getEntity()) == null) {
            return;
        }
        FoodResolver.RawFoodRank rank = FoodResolver.Resolve(event.getItem(), event.getEntity().level(), event.getEntity());
        if (rank.equals((Object)FoodResolver.RawFoodRank.NotACookableFood)) {
            return;
        }
        if (rank.equals((Object)FoodResolver.RawFoodRank.OkayToEat)) {
            return;
        }
        int effectId = EventBusHandlers.GetSessionEffectId(event.getEntity(), item);
        if (rank.equals((Object)FoodResolver.RawFoodRank.Severe)) {
            EventBusHandlers.ApplySevereEffect(event.getEntity(), effectId);
        } else if (rank.equals((Object)FoodResolver.RawFoodRank.Light)) {
            EventBusHandlers.ApplyLightEffect(event.getEntity(), effectId);
        } else if (rank.equals((Object)FoodResolver.RawFoodRank.Normal)) {
            EventBusHandlers.ApplyNormalEffect(event.getEntity(), effectId);
        }
    }

    private static int GetSessionEffectId(LivingEntity player, Item item) {
        int pl = player.getId();
        int it = item != null ? Item.getId((Item)item) : 0;
        int ho = Calendar.getInstance().get(11);
        int mi = Calendar.getInstance().get(12);
        return Math.abs(1500450271 * pl + 15487457 * it + 15485917 * ho + 71 * (mi < 30 ? 1 : 0)) % 100 + 1;
    }

    private static void ApplyLoadedEffect(LivingEntity player, int sessionEffectId, EffectPools.EffectLevel loaded) {
        int index;
        int r = sessionEffectId > 0 ? sessionEffectId : random.nextInt(100) + 1;
        for (index = 0; index < loaded.effects.length && r > loaded.effects[index].weight; r -= loaded.effects[index].weight, ++index) {
        }
        if (index < loaded.effects.length) {
            for (EffectPools.EffectInternal ei : loaded.effects[index].list) {
                Optional potionReference = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)ei.effect_id));
                if (potionReference.isEmpty()) continue;
                EventBusHandlers.ApplyEffectInternal(player, (Holder<MobEffect>)((Holder)potionReference.get()), ei.duration_in_sec, ei.effect_level);
            }
        }
    }

    private static void ApplyLightEffect(LivingEntity player, int sessionEffectId) {
        EventBusHandlers.ApplyLoadedEffect(player, sessionEffectId, EffectPools.getLight());
    }

    private static void ApplyNormalEffect(LivingEntity player, int sessionEffectId) {
        EventBusHandlers.ApplyLoadedEffect(player, sessionEffectId, EffectPools.getNormal());
    }

    private static void ApplySevereEffect(LivingEntity player, int sessionEffectId) {
        EventBusHandlers.ApplyLoadedEffect(player, sessionEffectId, EffectPools.getSevere());
    }

    private static void ApplyEffectInternal(LivingEntity player, Holder<MobEffect> potion, int durationInSeconds, int level) {
        int duration = (int)Math.round((double)(durationInSeconds * 20) * EventBusHandlers.GetDifficultyMultiplier(player));
        MobEffectInstance existing = player.getEffect(potion);
        if (existing != null) {
            float timeMultiplier = player.level().getRandom().nextFloat();
            if (potion == MobEffects.HUNGER) {
                timeMultiplier *= 0.5f;
            }
            duration = Math.round(timeMultiplier * (float)duration + 1.0f);
            duration += existing.getDuration();
            level = Math.max(level, existing.getAmplifier());
        }
        player.addEffect(new MobEffectInstance(potion, duration, level));
    }

    private static double GetDifficultyMultiplier(LivingEntity player) {
        if (player.level().getDifficulty() == Difficulty.EASY || player.level().getDifficulty() == Difficulty.PEACEFUL) {
            return (Double)OptionsHolder.COMMON.EasyDifDurationMultiplier.get();
        }
        if (player.level().getDifficulty() == Difficulty.NORMAL) {
            return (Double)OptionsHolder.COMMON.NormalDifDurationMultiplier.get();
        }
        return (Double)OptionsHolder.COMMON.HardDifDurationMultiplier.get();
    }
}

