/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EntitySubRegistryHelper
extends AbstractSubRegistryHelper<EntityType<?>, DeferredRegister<EntityType<?>>> {
    public EntitySubRegistryHelper(RegistryHelper parent, DeferredRegister<EntityType<?>> deferredRegister) {
        super(parent, deferredRegister);
    }

    public EntitySubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)parent.getModId()));
    }

    public <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> createEntity(String name, EntityType.EntityFactory<E> factory, MobCategory entityClassification, Consumer<EntityType.Builder<E>> builderConsumer) {
        return this.deferredRegister.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)entityClassification);
            builderConsumer.accept(builder);
            return builder.build(this.getParent().modId + ":" + name);
        });
    }

    public <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> createEntity(String name, EntityType.EntityFactory<E> factory, MobCategory entityClassification, float width, float height) {
        return this.deferredRegister.register(name, () -> this.createEntity(factory, entityClassification, name, width, height));
    }

    public <E extends Entity> EntityType<E> createEntity(EntityType.EntityFactory<E> factory, MobCategory entityClassification, String name, float width, float height) {
        ResourceLocation location = this.parent.prefix(name);
        return EntityType.Builder.of(factory, (MobCategory)entityClassification).sized(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).build(location.toString());
    }
}

