/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.EmptyResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;

public final class ConditionedResourceSelector {
    public static final Codec<ConditionedResourceSelector> DIRECT_CODEC = ExtraCodecs.JSON.flatXmap(element -> {
        try {
            return DataResult.success((Object)ConditionedResourceSelector.deserialize("selector", element));
        }
        catch (JsonParseException exception) {
            String message = exception.getMessage();
            return DataResult.error(() -> message);
        }
    }, selector -> {
        try {
            return DataResult.success((Object)selector.serialize());
        }
        catch (JsonParseException exception) {
            String message = exception.getMessage();
            return DataResult.error(() -> message);
        }
    });
    public static final Codec<ConditionedResourceSelector> CODEC = DIRECT_CODEC.fieldOf("selector").codec();
    public static final ConditionedResourceSelector EMPTY = new ConditionedResourceSelector(EmptyResourceSelector.INSTANCE);
    private static final ICondition[] NO_CONDITIONS = new ICondition[0];
    private final ResourceSelector<?> resourceSelector;
    private final ICondition[] conditions;

    public ConditionedResourceSelector(ResourceSelector<?> resourceSelector, ICondition ... conditions) {
        this.resourceSelector = resourceSelector;
        this.conditions = conditions;
    }

    public ConditionedResourceSelector(ResourceSelector<?> resourceSelector) {
        this(resourceSelector, NO_CONDITIONS);
    }

    public static ConditionedResourceSelector deserialize(String key, JsonElement element) throws JsonParseException {
        JsonPrimitive primitive;
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
            return new ConditionedResourceSelector(new NamesResourceSelector(ResourceLocation.parse((String)primitive.getAsString())));
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            if (!GsonHelper.isValidNode((JsonObject)jsonObject, (String)"conditions") || ICondition.getWithConditionalCodec((Codec)ConditionalOps.createConditionalCodec((Codec)Codec.unit((Object)Unit.INSTANCE), (String)"conditions"), (DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).isPresent()) {
                String type = GsonHelper.getAsString((JsonObject)jsonObject, (String)"type");
                ResourceSelector.Serializer<?> serializer = ResourceSelectorSerializers.INSTANCE.getSerializer(type);
                if (serializer != null) {
                    return new ConditionedResourceSelector((ResourceSelector<?>)serializer.deserialize(jsonObject.get("config")));
                }
                throw new JsonParseException("Unknown selector type: " + type);
            }
            return EMPTY;
        }
        if (element == null) {
            throw new JsonParseException("Missing '" + key + "' member!");
        }
        throw new JsonParseException("'" + key + "' must be a string or object!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonElement serialize() {
        ResourceSelector.Serializer<?> serializer;
        String type;
        ResourceSelector<?> selector;
        boolean hasConditions;
        ICondition[] conditions;
        block6: {
            conditions = this.conditions;
            hasConditions = conditions != null && conditions.length > 0;
            selector = this.resourceSelector;
            if (!hasConditions && selector instanceof NamesResourceSelector) {
                NamesResourceSelector namesResourceSelector = (NamesResourceSelector)selector;
                try {
                    Set<ResourceLocation> set;
                    Set<ResourceLocation> names = set = namesResourceSelector.names();
                    if (names.size() != 1) break block6;
                    return new JsonPrimitive(names.iterator().next().toString());
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        if ((type = ResourceSelectorSerializers.INSTANCE.getSerializerID(serializer = selector.getSerializer())) == null) {
            throw new JsonParseException("Could not find name for selector serializer: " + String.valueOf(serializer));
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(type));
        jsonObject.add("config", selector.serialize());
        if (!hasConditions) return jsonObject;
        JsonArray conditionsArray = new JsonArray();
        for (ICondition condition : conditions) {
            conditionsArray.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow(JsonParseException::new));
        }
        jsonObject.add("conditions", (JsonElement)conditionsArray);
        return jsonObject;
    }

    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select() {
        return this.resourceSelector.select();
    }

    public ResourceSelector<?> getResourceSelector() {
        return this.resourceSelector;
    }

    public ICondition[] getConditions() {
        return this.conditions;
    }
}

