/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public final class TagUtil {
    public static TagKey<Block> blockTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<Item> itemTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<EntityType<?>> entityTypeTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<Enchantment> enchantmentTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<Potion> potionTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.POTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<BlockEntityType<?>> blockEntityTypeTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<MobEffect> mobEffectTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<DamageType> damageTypeTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<TrimMaterial> trimMaterialTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<Biome> biomeTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static boolean isTagged(Holder<Biome> biome, TagKey<Biome> tagKey) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return false;
        }
        Optional tag = server.registryAccess().registryOrThrow(Registries.BIOME).getTag(tagKey);
        if (tag.isEmpty()) {
            return false;
        }
        return ((HolderSet.Named)tag.get()).contains(biome);
    }

    public static TagKey<Level> dimensionTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<DimensionType> dimensionTypeTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<ConfiguredFeature<?, ?>> configuredFeatureTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<PlacedFeature> placedFeatureTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<Structure> structureTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    public static TagKey<ConfiguredWorldCarver<?>> configuredCarverTag(String modid, String name) {
        return TagKey.create((ResourceKey)Registries.CONFIGURED_CARVER, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }
}

