/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions.loot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.core.registry.BlueprintLootConditions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class RaidCheckCondition
implements LootItemCondition {
    public static final MapCodec<RaidCheckCondition> CODEC = Codec.BOOL.optionalFieldOf("inverted", (Object)false).xmap(RaidCheckCondition::new, condition -> condition.inverted);
    private final boolean inverted;

    public RaidCheckCondition(boolean inverted) {
        this.inverted = inverted;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)BlueprintLootConditions.RAID_CHECK.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        return this.inverted != (entity != null && lootContext.getLevel().getRaidAt(entity.blockPosition()) != null);
    }
}

