/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicateSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigLootCondition
implements LootItemCondition {
    private final LootItemConditionType type;
    private final ModConfigSpec.ConfigValue<?> value;
    private final String valueID;
    private final Map<IConfigPredicate, Boolean> predicates;
    private final boolean inverted;

    public ConfigLootCondition(LootItemConditionType type, ModConfigSpec.ConfigValue<?> value, String valueID, Map<IConfigPredicate, Boolean> predicates, boolean inverted) {
        this.type = type;
        this.value = value;
        this.valueID = valueID;
        this.predicates = predicates;
        this.inverted = inverted;
    }

    public LootItemConditionType getType() {
        return this.type;
    }

    public boolean test(LootContext context) {
        boolean returnValue;
        if (this.predicates.size() > 0) {
            returnValue = this.predicates.keySet().stream().allMatch(c -> this.predicates.get(c).booleanValue() != c.test(this.value));
        } else {
            Object object = this.value.get();
            if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                returnValue = bool;
            } else {
                throw new IllegalStateException("Predicates required for non-boolean ConfigLootCondition, but none found");
            }
        }
        return this.inverted != returnValue;
    }

    public static class ConfigSerializer
    implements Codec<ConfigLootCondition> {
        private final Map<String, ModConfigSpec.ConfigValue<?>> configValues;
        private LootItemConditionType type;

        public ConfigSerializer(Map<String, ModConfigSpec.ConfigValue<?>> configValues) {
            this.configValues = configValues;
        }

        public static LootItemConditionType asType(Map<String, ModConfigSpec.ConfigValue<?>> configValues) {
            LootItemConditionType type;
            ConfigSerializer serializer = new ConfigSerializer(configValues);
            serializer.type = type = new LootItemConditionType(serializer.fieldOf("value"));
            return type;
        }

        public <T> DataResult<Pair<ConfigLootCondition, T>> decode(DynamicOps<T> ops, T input) {
            return ExtraCodecs.JSON.decode(ops, input).flatMap(pair -> {
                JsonElement jsonElement = (JsonElement)pair.getFirst();
                if (!(jsonElement instanceof JsonObject)) {
                    return DataResult.error(() -> "Expected a JSON object");
                }
                JsonObject json = (JsonObject)jsonElement;
                if (!json.has("value")) {
                    throw new JsonSyntaxException("Missing 'value', expected to find a string");
                }
                String name = GsonHelper.getAsString((JsonObject)json, (String)"value");
                ModConfigSpec.ConfigValue<?> configValue = this.configValues.get(name);
                if (configValue == null) {
                    throw new JsonSyntaxException("No config value of name '" + name + "' found");
                }
                HashMap<IConfigPredicate, Boolean> predicates = new HashMap<IConfigPredicate, Boolean>();
                if (GsonHelper.isValidNode((JsonObject)json, (String)"predicates")) {
                    for (JsonElement predicateElement : GsonHelper.getAsJsonArray((JsonObject)json, (String)"predicates")) {
                        if (!predicateElement.isJsonObject()) {
                            throw new JsonSyntaxException("Predicates must be an array of JsonObjects");
                        }
                        JsonObject predicateObject = predicateElement.getAsJsonObject();
                        ResourceLocation type = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)predicateObject, (String)"type"));
                        IConfigPredicateSerializer<?> serializer = ConfigValueCondition.Serializer.CONFIG_PREDICATE_SERIALIZERS.get(type);
                        if (serializer == null) {
                            throw new JsonSyntaxException("Unknown predicate type: " + String.valueOf(type));
                        }
                        predicates.put((IConfigPredicate)serializer.read(predicateObject), predicateObject.has("inverted") && GsonHelper.getAsBoolean((JsonObject)predicateObject, (String)"inverted"));
                    }
                } else if (!(configValue.get() instanceof Boolean)) {
                    throw new JsonSyntaxException("Missing 'predicates' for non-boolean config value '" + name + "', expected to find an array");
                }
                return DataResult.success((Object)Pair.of((Object)new ConfigLootCondition(this.type, configValue, name, predicates, json.has("inverted") && GsonHelper.getAsBoolean((JsonObject)json, (String)"inverted")), (Object)input));
            });
        }

        public <T> DataResult<T> encode(ConfigLootCondition value, DynamicOps<T> ops, T prefix) {
            JsonObject json = new JsonObject();
            json.addProperty("value", value.valueID);
            if (!value.predicates.isEmpty()) {
                JsonArray predicates = new JsonArray();
                for (Map.Entry<IConfigPredicate, Boolean> predicatePair : value.predicates.entrySet()) {
                    IConfigPredicate predicate = predicatePair.getKey();
                    ResourceLocation predicateID = predicate.getID();
                    JsonObject object = new JsonObject();
                    object.addProperty("type", predicateID.toString());
                    ConfigValueCondition.Serializer.CONFIG_PREDICATE_SERIALIZERS.get(predicateID).write(object, predicate);
                    object.addProperty("inverted", predicatePair.getValue());
                    predicates.add((JsonElement)object);
                }
                json.add("predicates", (JsonElement)predicates);
            }
            if (value.inverted) {
                json.addProperty("inverted", Boolean.valueOf(true));
            }
            return ExtraCodecs.JSON.encode((Object)json, ops, prefix);
        }
    }
}

