/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage.tracking;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public enum TrackedDataManager {
    INSTANCE;

    private final BiMap<ResourceLocation, TrackedData<?>> dataMap = HashBiMap.create();

    private TrackedDataManager() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public synchronized void registerData(ResourceLocation key, TrackedData<?> trackedData) {
        if (this.dataMap.containsKey((Object)key)) {
            throw new IllegalArgumentException(String.format("A Tracked Data with key '%s' is already registered!", key));
        }
        this.dataMap.put((Object)key, trackedData);
    }

    public <T> void setValue(Entity entity, TrackedData<T> trackedData, T value) {
        if (!this.dataMap.containsValue(trackedData)) {
            throw new IllegalArgumentException(String.format("No key is registered for this Tracked Data: %s", trackedData));
        }
        ((IDataManager)entity).setValue(trackedData, value);
    }

    public <T> T getValue(Entity entity, TrackedData<T> trackedData) {
        if (!this.dataMap.containsValue(trackedData)) {
            throw new IllegalArgumentException(String.format("No key is registered for this Tracked Data: %s", trackedData));
        }
        return ((IDataManager)entity).getValue(trackedData);
    }

    @Nullable
    public TrackedData<?> getTrackedData(ResourceLocation resourceLocation) {
        return (TrackedData)this.dataMap.get((Object)resourceLocation);
    }

    @Nullable
    public ResourceLocation getKey(TrackedData<?> trackedData) {
        return (ResourceLocation)this.dataMap.inverse().get(trackedData);
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        Set<IDataManager.DataEntry<?>> entries;
        Entity target = event.getTarget();
        if (!target.level().isClientSide && !(entries = ((IDataManager)target).getEntries(true)).isEmpty()) {
            NetworkUtil.updateTrackedData((ServerPlayer)event.getEntity(), target.getId(), entries);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Set<IDataManager.DataEntry<?>> entries;
        Entity target = event.getEntity();
        if (!target.level().isClientSide && !(entries = ((IDataManager)target).getEntries(false)).isEmpty()) {
            NetworkUtil.updateTrackedData(target, entries);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        if (!original.level().isClientSide) {
            Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = ((IDataManager)original).getDataMap();
            if (event.isWasDeath()) {
                dataMap.entrySet().removeIf(entry -> !((TrackedData)entry.getKey()).isPersistent());
            }
            dataMap.values().forEach(IDataManager.DataEntry::markDirty);
            ((IDataManager)event.getEntity()).setDataMap(dataMap);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        IDataManager dataManager = (IDataManager)player;
        Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = dataManager.getDataMap();
        dataMap.values().forEach(IDataManager.DataEntry::markDirty);
        ((IDataManager)player).setDataMap(dataMap);
    }
}

