/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage.tracking;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.blueprint.core.Blueprint;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public interface IDataManager {
    public <T> void setValue(TrackedData<T> var1, T var2);

    public <T> T getValue(TrackedData<T> var1);

    public boolean isDirty();

    public void clean();

    public Map<TrackedData<?>, DataEntry<?>> getDataMap();

    public void setDataMap(Map<TrackedData<?>, DataEntry<?>> var1);

    public Set<DataEntry<?>> getDirtyEntries();

    public Set<DataEntry<?>> getEntries(boolean var1);

    public static class DataEntry<T> {
        public static final StreamCodec<RegistryFriendlyByteBuf, DataEntry<?>> STREAM_CODEC = StreamCodec.of((buf, entry) -> entry.write((RegistryFriendlyByteBuf)buf), DataEntry::read);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<DataEntry<?>>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        private final TrackedData<T> trackedData;
        private T value;
        private boolean dirty;

        public DataEntry(TrackedData<T> trackedData) {
            this.trackedData = trackedData;
            this.value = trackedData.getDefaultValue();
        }

        public static DataEntry<?> read(RegistryFriendlyByteBuf buffer) {
            ResourceLocation location = buffer.readResourceLocation();
            TrackedData<?> trackedData = TrackedDataManager.INSTANCE.getTrackedData(location);
            Objects.requireNonNull(trackedData, String.format("Tracked Data does not exist for id %s", location));
            DataEntry entry = new DataEntry(trackedData);
            entry.readValue(buffer, true);
            return entry;
        }

        public CompoundTag encode(CompoundTag tag, RegistryOps<Tag> ops) {
            DataResult result = this.getTrackedData().getCodec().codec().encode(this.value, ops, (Object)tag);
            Optional error = result.error();
            if (error.isPresent()) {
                throw new RuntimeException("Error encoding tracked data: " + String.valueOf(error.get()));
            }
            Object t = result.result().get();
            if (!(t instanceof CompoundTag)) {
                throw new RuntimeException("Tracked data was not encoded as a compound tag");
            }
            CompoundTag compoundTag = (CompoundTag)t;
            return compoundTag;
        }

        public TrackedData<T> getTrackedData() {
            return this.trackedData;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value, boolean dirty) {
            this.value = value;
            this.dirty = dirty;
        }

        public void markDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clean() {
            this.dirty = false;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(Objects.requireNonNull(TrackedDataManager.INSTANCE.getKey(this.trackedData)));
            this.getTrackedData().getStreamCodec().encode((Object)buffer, this.getValue());
        }

        public void readValue(RegistryFriendlyByteBuf buffer, boolean dirty) {
            this.value = this.getTrackedData().getStreamCodec().decode((Object)buffer);
            this.dirty = dirty;
        }

        public void readValue(CompoundTag tag, RegistryOps<Tag> ops, boolean dirty) {
            this.dirty = dirty;
            this.value = this.getTrackedData().getCodec().codec().decode(ops, (Object)tag).mapOrElse(Pair::getFirst, error -> {
                Blueprint.LOGGER.error("Error while decoding tracked data {}:\n{}", (Object)tag, (Object)error.message());
                Blueprint.LOGGER.warn("Using default value instead");
                return this.getTrackedData().getDefaultValue();
            });
        }
    }
}

