/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleTagStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedTagStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.condition.AndStructureCondition;
import com.teamabnormals.blueprint.common.world.modification.structure.condition.BiomeStructureCondition;
import com.teamabnormals.blueprint.common.world.modification.structure.condition.ChanceStructureCondition;
import com.teamabnormals.blueprint.common.world.modification.structure.condition.NotStructureCondition;
import com.teamabnormals.blueprint.common.world.modification.structure.condition.OrStructureCondition;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber(modid="blueprint")
public final class StructureRepaletterManager {
    static final BasicRegistry<MapCodec<? extends StructureRepaletter>> REPALLETER_SERIALIZERS = new BasicRegistry();
    static final BasicRegistry<MapCodec<? extends StructureRepaletter.Replacer>> REPLACER_SERIALIZERS = new BasicRegistry();
    static final BasicRegistry<MapCodec<? extends StructureRepaletter.Condition>> CONDITION_SERIALIZERS = new BasicRegistry();
    private static final IdentityHashMap<ResourceKey<Structure>, StructureRepaletterEntry[]> ASSIGNED_REPALLETERS = new IdentityHashMap();
    private static final ThreadLocal<ActiveData> ACTIVE_DATA = ThreadLocal.withInitial(ActiveData::new);

    @SubscribeEvent
    public static void onServerStarted(ServerAboutToStartEvent event) {
        ASSIGNED_REPALLETERS.clear();
        Set entries = event.getServer().registryAccess().registryOrThrow(BlueprintDataPackRegistries.STRUCTURE_REPALETTERS).entrySet();
        IdentityHashMap<ResourceKey, ArrayList> assignedUnsortedEntries = new IdentityHashMap<ResourceKey, ArrayList>();
        for (Map.Entry entry : entries) {
            StructureRepaletterEntry structureRepaletterEntry = (StructureRepaletterEntry)entry.getValue();
            structureRepaletterEntry.structures().stream().forEach(structureHolder -> assignedUnsortedEntries.computeIfAbsent((ResourceKey)structureHolder.unwrapKey().orElseThrow(), __ -> new ArrayList()).add(structureRepaletterEntry));
        }
        assignedUnsortedEntries.forEach((location, structureRepaletterEntries) -> ASSIGNED_REPALLETERS.put((ResourceKey<Structure>)location, (StructureRepaletterEntry[])structureRepaletterEntries.stream().sorted(Comparator.comparing(StructureRepaletterEntry::priority)).toArray(StructureRepaletterEntry[]::new)));
    }

    public static synchronized void registerRepalleter(ResourceLocation name, MapCodec<? extends StructureRepaletter> codec) {
        REPALLETER_SERIALIZERS.register(name, codec);
    }

    public static synchronized void registerReplacer(ResourceLocation name, MapCodec<? extends StructureRepaletter.Replacer> codec) {
        REPLACER_SERIALIZERS.register(name, codec);
    }

    public static void registerRepalleter(ResourceLocation name, MapCodec<? extends StructureRepaletter> codec, MapCodec<? extends StructureRepaletter.Replacer> replacerCodec) {
        StructureRepaletterManager.registerRepalleter(name, codec);
        StructureRepaletterManager.registerReplacer(name, replacerCodec);
    }

    public static synchronized void registerCondition(ResourceLocation name, MapCodec<? extends StructureRepaletter.Condition> codec) {
        CONDITION_SERIALIZERS.register(name, codec);
    }

    @Nullable
    public static StructureRepaletterEntry[] getRepalettersForStructure(ResourceKey<Structure> structure) {
        return ASSIGNED_REPALLETERS.get(structure);
    }

    public static void updateRandomSource(RandomSource random) {
        StructureRepaletterManager.ACTIVE_DATA.get().random = random;
    }

    public static void updateActiveRepaletters(@Nullable ArrayList<Entry> entries, @Nullable Holder<StructurePieceType> pieceType) {
        ActiveData activeData = ACTIVE_DATA.get();
        if (entries == null) {
            activeData.reset();
            return;
        }
        ArrayList<StructureRepaletter.Replacer> activeReplacers = new ArrayList<StructureRepaletter.Replacer>();
        if (pieceType != null) {
            for (Entry entry : entries) {
                Optional<HolderSet<StructurePieceType>> pieces = entry.pieces();
                if (!pieces.isEmpty() && !pieces.get().contains(pieceType)) continue;
                activeReplacers.add(entry.replacer());
            }
        } else {
            for (Entry entry : entries) {
                if (!entry.shouldApplyToAfterPlace()) continue;
                activeReplacers.add(entry.replacer());
            }
        }
        activeData.replacers = (StructureRepaletter.Replacer[])activeReplacers.toArray(StructureRepaletter.Replacer[]::new);
    }

    public static BlockState getBlockState(ServerLevelAccessor level, BlockState state) {
        ActiveData activeData = ACTIVE_DATA.get();
        StructureRepaletter.Replacer[] replacers = activeData.replacers;
        int length = replacers.length;
        if (length == 0) {
            return state;
        }
        RandomSource random = activeData.random;
        for (int i = 0; i < length; ++i) {
            BlockState replacement = replacers[i].getReplacement(level, state, random);
            if (replacement == null) continue;
            return replacement;
        }
        return state;
    }

    public static void reset() {
        ACTIVE_DATA.get().reset();
    }

    static {
        StructureRepaletterManager.registerRepalleter(Blueprint.location("simple"), SimpleStructureRepaletter.CODEC, SimpleStructureRepaletter.CODEC);
        StructureRepaletterManager.registerRepalleter(Blueprint.location("simple_tag"), SimpleTagStructureRepaletter.CODEC, SimpleTagStructureRepaletter.CODEC);
        StructureRepaletterManager.registerRepalleter(Blueprint.location("weighted"), WeightedStructureRepaletter.CODEC, WeightedStructureRepaletter.CODEC);
        StructureRepaletterManager.registerRepalleter(Blueprint.location("weighted_tag"), WeightedTagStructureRepaletter.CODEC, WeightedTagStructureRepaletter.CODEC);
        StructureRepaletterManager.registerCondition(Blueprint.location("not"), NotStructureCondition.CODEC);
        StructureRepaletterManager.registerCondition(Blueprint.location("and"), AndStructureCondition.CODEC);
        StructureRepaletterManager.registerCondition(Blueprint.location("or"), OrStructureCondition.CODEC);
        StructureRepaletterManager.registerCondition(Blueprint.location("biome"), BiomeStructureCondition.CODEC);
        StructureRepaletterManager.registerCondition(Blueprint.location("chance"), ChanceStructureCondition.CODEC);
    }

    private static final class ActiveData {
        private static final StructureRepaletter.Replacer[] EMPTY_REPLACER = new StructureRepaletter.Replacer[0];
        private StructureRepaletter.Replacer[] replacers = EMPTY_REPLACER;
        private RandomSource random;

        private ActiveData() {
        }

        private void reset() {
            this.replacers = EMPTY_REPLACER;
        }
    }

    public record Entry(Optional<HolderSet<StructurePieceType>> pieces, boolean shouldApplyToAfterPlace, StructureRepaletter.Replacer replacer) {
        public static final String KEY = "blueprint:repaletters";
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE_PIECE).optionalFieldOf("pieces").forGetter(Entry::pieces), (App)Codec.BOOL.optionalFieldOf("should_apply_to_after_place", (Object)false).forGetter(Entry::shouldApplyToAfterPlace), (App)StructureRepaletter.Replacer.CODEC.fieldOf("replacer").forGetter(Entry::replacer)).apply((Applicative)instance, Entry::new));
    }
}

