/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.chunk;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.teamabnormals.blueprint.common.world.modification.chunk.ChunkGeneratorModifierSerializers;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber(modid="blueprint")
public final class ChunkGeneratorModificationManager
extends SimpleJsonResourceReloadListener {
    public static final String PATH = "dimension/chunk_generator";
    private final EnumMap<EventPriority, LinkedList<ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>>>> prioritizedModifiers = new EnumMap(EventPriority.class);
    private static ChunkGeneratorModificationManager INSTANCE;
    private final RegistryOps<JsonElement> registryOps;

    public ChunkGeneratorModificationManager(RegistryOps<JsonElement> registryOps) {
        super(new Gson(), "modifiers/dimension/chunk_generator");
        this.registryOps = registryOps;
    }

    @SubscribeEvent
    public static void onReloadListener(AddReloadListenerEvent event) {
        try {
            INSTANCE = new ChunkGeneratorModificationManager(DataUtil.createRegistryOps(event.getServerResources()));
            event.addListener((PreparableReloadListener)INSTANCE);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        RegistryOps<JsonElement> registryOps = this.registryOps;
        int groupsLoaded = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>> modifierGroup = ObjectModifierGroup.deserialize(location.toString(), entry.getValue().getAsJsonObject(), registryOps, ChunkGeneratorModifierSerializers.REGISTRY, true, true);
                this.prioritizedModifiers.computeIfAbsent(modifierGroup.priority(), __ -> new LinkedList()).add(modifierGroup);
                ++groupsLoaded;
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Blueprint.LOGGER.error("Parsing error loading Chunk Generator Modifier Group: {}", (Object)location, (Object)exception);
            }
        }
        Blueprint.LOGGER.info("Chunk Generator Modification Manager has loaded {} modifier groups", (Object)groupsLoaded);
    }

    static {
        for (EventPriority priority : EventPriority.values()) {
            NeoForge.EVENT_BUS.addListener(event -> {
                if (INSTANCE == null) {
                    return;
                }
                EnumMap<EventPriority, LinkedList<ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>>>> prioritizedModifiers = ChunkGeneratorModificationManager.INSTANCE.prioritizedModifiers;
                if (prioritizedModifiers == null) {
                    return;
                }
                LinkedList<ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>>> modifierGroups = prioritizedModifiers.get(priority);
                if (modifierGroups == null) {
                    return;
                }
                RegistryAccess.Frozen registryAccess = event.getServer().registryAccess();
                Registry dimensions = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
                Set keySet = dimensions.keySet();
                HashMap<ResourceLocation, LinkedList> assignedModifiers = new HashMap<ResourceLocation, LinkedList>();
                for (ObjectModifierGroup objectModifierGroup : modifierGroups) {
                    Either<Set<ResourceLocation>, Predicate<ResourceLocation>> either = objectModifierGroup.selector().select();
                    Optional locations = either.left();
                    if (locations.isPresent()) {
                        ((Set)locations.get()).forEach(location -> assignedModifiers.computeIfAbsent((ResourceLocation)location, __ -> new LinkedList()).addAll(modifierGroup.modifiers()));
                        continue;
                    }
                    Predicate predicate = (Predicate)either.right().get();
                    for (ResourceLocation dimensionKey : keySet) {
                        if (!predicate.test(dimensionKey)) continue;
                        assignedModifiers.computeIfAbsent(dimensionKey, __ -> new LinkedList()).addAll(objectModifierGroup.modifiers());
                    }
                }
                for (Map.Entry entry : dimensions.entrySet()) {
                    LinkedList modifiers = (LinkedList)assignedModifiers.get(((ResourceKey)entry.getKey()).location());
                    if (modifiers == null) continue;
                    ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).generator();
                    modifiers.forEach(configured -> configured.modify(chunkGenerator));
                }
            });
        }
    }
}

