/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.DataVisitor;
import com.teamabnormals.blueprint.common.remolder.data.ElementType;
import com.teamabnormals.blueprint.common.remolder.data.VariableDataVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public abstract class Molding
extends MethodVisitor
implements Opcodes {
    private final HashMap<String, Pair<DataType<?>, Integer>> localVariables = new HashMap();
    private final ArrayList<VariableDataVisitor.Provided<?>> providedVariables = new ArrayList();
    private final String fieldOwnerTypeName;
    private final VariableDataVisitor fieldOwnerVariable;
    private int localVariableOffset;

    public Molding(MethodVisitor method, String fieldOwnerTypeName, VariableDataVisitor fieldOwnerVariable, int localVariableOffset) {
        super(589824, method);
        this.fieldOwnerTypeName = fieldOwnerTypeName;
        this.fieldOwnerVariable = fieldOwnerVariable;
        this.localVariableOffset = localVariableOffset;
    }

    public final int localVarIndex(@Nullable String name, DataType<?> type) {
        if (name != null) {
            Pair variable = this.localVariables.get(name);
            if (variable == null) {
                variable = Pair.of(type, (Object)this.localVariableOffset++);
                this.localVariables.put(name, variable);
            } else if (!((DataType)variable.getFirst()).getClazz().isAssignableFrom(type.getClazz())) {
                throw new IllegalArgumentException("Variable with name '" + name + "' exists that has type incompatible with " + String.valueOf(type));
            }
            return (Integer)variable.getSecond();
        }
        return this.localVariableOffset++;
    }

    public final <T> VariableDataVisitor.Provided<T> provideVariable(String name, DataType<T> type, T value) {
        VariableDataVisitor.Provided<T> provided = new VariableDataVisitor.Provided<T>("provided" + this.providedVariables.size() + "$" + name, type, value);
        this.providedVariables.add(provided);
        return provided;
    }

    public final ArrayList<VariableDataVisitor.Provided<?>> getProvidedVariables() {
        return this.providedVariables;
    }

    public String getFieldOwnerTypeName() {
        return this.fieldOwnerTypeName;
    }

    public final VariableDataVisitor getFieldOwnerVariable() {
        return this.fieldOwnerVariable;
    }

    public final void checkThenCast(Class<?> from, DataType<?> to) {
        if (!to.getClazz().isAssignableFrom(from)) {
            this.visitTypeInsn(192, to.getInternalName());
        }
    }

    protected final void prepareChildVisit(DataVisitor object, DataVisitor key, Class<?> from, DataType<?> to) {
        object.visit(this);
        this.checkThenCast(from, to);
        key.visit(this);
    }

    public abstract DataType<?> getDataType();

    public abstract DataType<?> getListType();

    public abstract DataType<?> getMapType();

    public abstract DataType<?> getNullType();

    public abstract DataType<?> getRepresentationType(DataType<?> var1) throws UnsupportedOperationException;

    @Nullable
    public abstract ElementType getElementType(DataType<?> var1);

    public abstract void element(DataVisitor var1) throws UnsupportedOperationException;

    public abstract void convert(DataType<?> var1, DataType<?> var2) throws UnsupportedOperationException;

    public abstract void toString(DataType<?> var1) throws UnsupportedOperationException;

    public abstract void testElementalList();

    public abstract void testElementalMap();

    public abstract void testStringElement();

    public abstract void testNumericalElement();

    public abstract void testBooleanElement();

    public abstract void size(DataType<?> var1) throws UnsupportedOperationException;

    public abstract void get(DataVisitor var1, @Nullable DataVisitor var2) throws UnsupportedOperationException;

    public abstract void set(DataVisitor var1, @Nullable DataVisitor var2, DataVisitor var3) throws UnsupportedOperationException;

    public abstract void add(DataVisitor var1, @Nullable DataVisitor var2, DataVisitor var3) throws UnsupportedOperationException;

    public abstract void remove(DataVisitor var1, @Nullable DataVisitor var2) throws UnsupportedOperationException;

    public abstract void clear(DataType<?> var1) throws UnsupportedOperationException;

    public static interface Factory {
        public Molding create(MethodVisitor var1, String var2, VariableDataVisitor var3, int var4);
    }
}

