/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public abstract class BlueprintTreeFeature
extends Feature<TreeConfiguration> {
    public boolean placeDirt;

    public BlueprintTreeFeature(Codec<TreeConfiguration> config) {
        this(true, config);
    }

    public BlueprintTreeFeature(boolean placeDirt, Codec<TreeConfiguration> config) {
        super(config);
        this.placeDirt = placeDirt;
    }

    public boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        TreeInfo info = new TreeInfo(context);
        if (this.canSurvive(level, origin)) {
            this.doPlace(context, info);
            for (BlockPos logPos2 : info.logMap().keySet()) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)logPos2) && logPos2.getY() <= level.getMaxBuildHeight()) continue;
                return false;
            }
            for (BlockPos foliagePos2 : info.foliageMap().keySet()) {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)foliagePos2) && foliagePos2.getY() <= level.getMaxBuildHeight()) continue;
                return false;
            }
            this.doMidPlace(context, info);
            info.logMap().forEach((logPos, logState) -> {
                level.setBlock(logPos, logState, 19);
                if (logPos.getY() == origin.getY() && this.placeDirt) {
                    BlueprintTreeFeature.setDirtAt(level, random, logPos.below(), config);
                }
            });
            info.foliageMap().forEach((foliagePos, foliageState) -> {
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)foliagePos)) {
                    if (foliageState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        foliageState = (BlockState)foliageState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(foliagePos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
                    }
                    if (!foliageState.isAir()) {
                        level.setBlock(foliagePos, foliageState, 19);
                    }
                }
            });
            HashSet decorationPositions = Sets.newHashSet();
            BiConsumer<BlockPos, BlockState> decorationSetter = (decorationPos, state) -> {
                decorationPositions.add(decorationPos.immutable());
                level.setBlock(decorationPos, state, 19);
            };
            if (!config.decorators.isEmpty()) {
                TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)level, decorationSetter, random, info.logMap().keySet(), info.foliageMap().keySet(), (Set)Sets.newHashSet());
                config.decorators.forEach(decorator -> decorator.place(decoratorContext));
            }
            this.doPostPlace(context, info);
            return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat(info.logMap().keySet(), info.foliageMap().keySet(), (Iterable)decorationPositions)).map(boundingBox -> {
                DiscreteVoxelShape shape = TreeFeature.updateLeaves((LevelAccessor)level, (BoundingBox)boundingBox, info.logMap().keySet(), (Set)decorationPositions, Set.of());
                StructureTemplate.updateShapeAtEdge((LevelAccessor)level, (int)3, (DiscreteVoxelShape)shape, (int)boundingBox.minX(), (int)boundingBox.minY(), (int)boundingBox.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public abstract BlockState getSapling();

    public boolean canSurvive(WorldGenLevel level, BlockPos pos) {
        return this.getSapling().canSurvive((LevelReader)level, pos);
    }

    public abstract void doPlace(FeaturePlaceContext<TreeConfiguration> var1, TreeInfo var2);

    public void doMidPlace(FeaturePlaceContext<TreeConfiguration> context, TreeInfo info) {
    }

    public void doPostPlace(FeaturePlaceContext<TreeConfiguration> context, TreeInfo info) {
    }

    public static void setDirtAt(WorldGenLevel level, RandomSource random, BlockPos pos, TreeConfiguration config) {
        if (config.forceDirt || !BlueprintTreeFeature.isDirt((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, config.dirtProvider.getState(random, pos), 19);
        }
    }

    public static boolean isDirt(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, state -> Feature.isDirt((BlockState)state) && !state.is(Blocks.GRASS_BLOCK) && !state.is(Blocks.MYCELIUM));
    }

    public record TreeInfo(FeaturePlaceContext<TreeConfiguration> context, HashMap<BlockPos, BlockState> logMap, HashMap<BlockPos, BlockState> foliageMap) {
        public TreeInfo(FeaturePlaceContext<TreeConfiguration> context) {
            this(context, Maps.newHashMap(), Maps.newHashMap());
        }

        public void addLog(BlockPos pos, BlockState state) {
            this.logMap.put(pos.immutable(), state);
        }

        public void addLog(BlockPos pos) {
            this.addLog(pos, ((TreeConfiguration)this.context.config()).trunkProvider.getState(this.context.random(), pos));
        }

        public void addAxisLog(BlockPos pos, Direction.Axis axis) {
            BlockState state = ((TreeConfiguration)this.context.config()).trunkProvider.getState(this.context.random(), pos);
            if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
                this.addLog(pos, (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis));
            } else {
                this.addLog(pos);
            }
        }

        public void addAxisLog(BlockPos pos, Direction direction) {
            this.addAxisLog(pos, direction.getAxis());
        }

        public void addFoliage(BlockPos pos, BlockState state) {
            this.foliageMap.put(pos.immutable(), state);
        }

        public void addFoliage(BlockPos pos) {
            this.addFoliage(pos, ((TreeConfiguration)this.context.config()).foliageProvider.getState(this.context.random(), pos));
        }
    }
}

