/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.entity;

import com.teamabnormals.blueprint.core.events.FallingBlockEvent;
import com.teamabnormals.blueprint.core.registry.BlueprintEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlueprintFallingBlockEntity
extends FallingBlockEntity
implements IEntityWithComplexSpawn {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean dropsBlockLoot = true;
    private boolean allowsPlacing = true;

    public BlueprintFallingBlockEntity(EntityType<? extends FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public BlueprintFallingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)BlueprintEntityTypes.FALLING_BLOCK.get()), level);
        this.blockState = state;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    public static BlueprintFallingBlockEntity fall(Level level, BlockPos pos, BlockState state) {
        BlueprintFallingBlockEntity fallingblockentity = new BlueprintFallingBlockEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)) : state);
        FallingBlockEntity fallingblockentity1 = FallingBlockEvent.onBlockFall(level, pos, state, fallingblockentity);
        if (fallingblockentity1 instanceof BlueprintFallingBlockEntity) {
            fallingblockentity = (BlueprintFallingBlockEntity)fallingblockentity1;
        }
        level.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)fallingblockentity);
        return fallingblockentity;
    }

    public void tick() {
        if (this.blockState.isAir()) {
            this.discard();
        } else {
            Block block = this.blockState.getBlock();
            ++this.time;
            if (!this.isNoGravity()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (FallingBlockEvent.onFallingBlockTick(this)) {
                return;
            }
            if (!this.level().isClientSide) {
                BlockHitResult blockhitresult;
                BlockPos blockpos = this.blockPosition();
                boolean flag = this.blockState.getBlock() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.blockState.canBeHydrated((BlockGetter)this.level(), blockpos, this.level().getFluidState(blockpos), blockpos);
                double d0 = this.getDeltaMovement().lengthSqr();
                if (flag && d0 > 1.0 && (blockhitresult = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).getType() != HitResult.Type.MISS && this.blockState.canBeHydrated((BlockGetter)this.level(), blockpos, this.level().getFluidState(blockhitresult.getBlockPos()), blockhitresult.getBlockPos())) {
                    blockpos = blockhitresult.getBlockPos();
                    flag1 = true;
                }
                if (!this.onGround() && !flag1) {
                    if (!(this.level().isClientSide || (this.time <= 100 || blockpos.getY() > this.level().getMinBuildHeight() && blockpos.getY() <= this.level().getMaxBuildHeight()) && this.time <= 600)) {
                        if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            this.spawnDrops();
                        }
                        this.discard();
                    }
                } else {
                    BlockState blockstate = this.level().getBlockState(blockpos);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (!blockstate.is(Blocks.MOVING_PISTON)) {
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag2 = blockstate.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockpos, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                            boolean flag3 = FallingBlock.isFree((BlockState)this.level().getBlockState(blockpos.below())) && (!flag || !flag1);
                            boolean bl = flag4 = this.blockState.canSurvive((LevelReader)this.level(), blockpos) && !flag3;
                            if (flag2 && flag4) {
                                if (this.blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockpos).getType() == Fluids.WATER) {
                                    this.blockState = (BlockState)this.blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.allowsPlacing && this.level().setBlock(blockpos, this.blockState, 3)) {
                                    BlockEntity blockentity;
                                    ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.level().getBlockState(blockpos)));
                                    this.discard();
                                    if (block instanceof Fallable) {
                                        ((Fallable)block).onLand(this.level(), blockpos, this.blockState, blockstate, (FallingBlockEntity)this);
                                    }
                                    if (this.blockData != null && this.blockState.hasBlockEntity() && (blockentity = this.level().getBlockEntity(blockpos)) != null) {
                                        CompoundTag compoundtag = blockentity.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess());
                                        for (String s : this.blockData.getAllKeys()) {
                                            compoundtag.put(s, this.blockData.get(s).copy());
                                        }
                                        try {
                                            blockentity.loadWithComponents(compoundtag, (HolderLookup.Provider)this.level().registryAccess());
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        blockentity.setChanged();
                                    }
                                } else if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.discard();
                                    this.callOnBrokenAfterFall(block, blockpos);
                                    this.spawnDrops();
                                }
                            } else {
                                this.discard();
                                if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.callOnBrokenAfterFall(block, blockpos);
                                    this.spawnDrops();
                                }
                            }
                        } else {
                            this.discard();
                            this.callOnBrokenAfterFall(block, blockpos);
                        }
                    }
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    public void setDropsBlockLoot(boolean dropsLoot) {
        this.dropsBlockLoot = dropsLoot;
    }

    public void setAllowsPlacing(boolean allowsPlacing) {
        this.allowsPlacing = allowsPlacing;
    }

    public void setBlockState(BlockState state) {
        this.blockState = state;
    }

    protected void spawnDrops() {
        if (this.dropsBlockLoot) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY);
            this.blockState.getDrops(builder).forEach(arg_0 -> ((BlueprintFallingBlockEntity)this).spawnAtLocation(arg_0));
        } else {
            this.spawnAtLocation((ItemLike)this.blockState.getBlock());
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DropsBlockLoot", this.dropsBlockLoot);
        compound.putBoolean("AllowsPlacing", this.allowsPlacing);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DropsBlockLoot", 99)) {
            this.dropsBlockLoot = compound.getBoolean("DropsBlockLoot");
        }
        if (compound.contains("AllowsPlacing", 99)) {
            this.allowsPlacing = compound.getBoolean("AllowsPlacing");
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(Block.getId((BlockState)this.blockState));
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        this.blockState = Block.stateById((int)buffer.readInt());
    }
}

