/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer.texture.atlas;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.client.renderer.texture.atlas.BlueprintSpriteSources;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.FastColor;
import org.slf4j.Logger;

public class BlueprintPalettedPermutations
implements SpriteSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<BlueprintPalettedPermutations> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.mapEither((MapCodec)Codec.list((Codec)SpriteSources.CODEC).fieldOf("sources"), (MapCodec)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("textures")).forGetter(permutations -> permutations.sourcesOrTextures), (App)ResourceLocation.CODEC.fieldOf("palette_key").forGetter(permutations -> permutations.paletteKey), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.CODEC).fieldOf("permutations").forGetter(permutations -> permutations.permutations)).apply((Applicative)instance, BlueprintPalettedPermutations::new));
    private final Either<List<SpriteSource>, List<ResourceLocation>> sourcesOrTextures;
    private final Map<String, ResourceLocation> permutations;
    private final ResourceLocation paletteKey;

    public BlueprintPalettedPermutations(Either<List<SpriteSource>, List<ResourceLocation>> sourcesOrTextures, ResourceLocation p_266681_, Map<String, ResourceLocation> p_266741_) {
        this.sourcesOrTextures = sourcesOrTextures;
        this.permutations = p_266741_;
        this.paletteKey = p_266681_;
    }

    public void run(ResourceManager manager, SpriteSource.Output output) {
        Supplier supplier = Suppliers.memoize(() -> BlueprintPalettedPermutations.loadPaletteEntryFromImage(manager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> BlueprintPalettedPermutations.lambda$run$6(map, (java.util.function.Supplier)supplier, manager, arg_0, arg_1));
        Iterator locationIterator = (Iterator)this.sourcesOrTextures.map(sources -> {
            final HashMap tempOutputMap = new HashMap();
            SpriteSource.Output tempOutput = new SpriteSource.Output(){

                public void add(ResourceLocation location, SpriteSource.SpriteSupplier spriteSupplier) {
                    SpriteSource.SpriteSupplier oldSupplier = tempOutputMap.put(location, spriteSupplier);
                    if (oldSupplier != null) {
                        oldSupplier.discard();
                    }
                }

                public void removeAll(Predicate<ResourceLocation> predicate) {
                    Iterator iterator = tempOutputMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!predicate.test((ResourceLocation)entry.getKey())) continue;
                        ((SpriteSource.SpriteSupplier)entry.getValue()).discard();
                        iterator.remove();
                    }
                }
            };
            for (SpriteSource source : sources) {
                source.run(manager, tempOutput);
            }
            return tempOutputMap.keySet().iterator();
        }, List::iterator);
        while (locationIterator.hasNext()) {
            ResourceLocation location = (ResourceLocation)locationIterator.next();
            ResourceLocation resourcelocation1 = TEXTURE_ID_CONVERTER.idToFile(location);
            Optional optional = manager.getResource(resourcelocation1);
            if (optional.isEmpty()) {
                LOGGER.warn("Unable to find texture {}", (Object)resourcelocation1);
                continue;
            }
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(resourcelocation1, (Resource)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                ResourceLocation resourcelocation2 = location.withSuffix("_" + (String)entry.getKey());
                output.add(resourcelocation2, (SpriteSource.SpriteSupplier)new PalettedSpriteSupplier(lazyloadedimage, (java.util.function.Supplier)entry.getValue(), resourcelocation2));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(p_266776_.length);
        for (int i = 0; i < p_266839_.length; ++i) {
            int j = p_266839_[i];
            if (FastColor.ABGR32.alpha((int)j) == 0) continue;
            int2intmap.put(FastColor.ABGR32.transparent((int)j), p_266776_[i]);
        }
        return arg_0 -> BlueprintPalettedPermutations.lambda$createPaletteMapping$8((Int2IntMap)int2intmap, arg_0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int[] loadPaletteEntryFromImage(ResourceManager p_267184_, ResourceLocation p_267059_) {
        Optional optional = p_267184_.getResource(TEXTURE_ID_CONVERTER.idToFile(p_267059_));
        if (optional.isEmpty()) {
            LOGGER.error("Failed to load palette image {}", (Object)p_267059_);
            throw new IllegalArgumentException();
        }
        try (InputStream inputstream = ((Resource)optional.get()).open();){
            int[] nArray;
            block15: {
                NativeImage nativeimage = NativeImage.read((InputStream)inputstream);
                try {
                    nArray = nativeimage.getPixelsRGBA();
                    if (nativeimage == null) break block15;
                }
                catch (Throwable throwable) {
                    if (nativeimage != null) {
                        try {
                            nativeimage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeimage.close();
            }
            return nArray;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load texture {}", (Object)p_267059_, (Object)exception);
            throw new IllegalArgumentException();
        }
    }

    public SpriteSourceType type() {
        return BlueprintSpriteSources.PALETTED_PERMUTATIONS;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$8(Int2IntMap int2intmap, int p_267899_) {
        int k = FastColor.ABGR32.alpha((int)p_267899_);
        if (k == 0) {
            return p_267899_;
        }
        int l = FastColor.ABGR32.transparent((int)p_267899_);
        int i1 = int2intmap.getOrDefault(l, FastColor.ABGR32.opaque((int)l));
        int j1 = FastColor.ABGR32.alpha((int)i1);
        return FastColor.ABGR32.color((int)(k * j1 / 255), (int)i1);
    }

    private static /* synthetic */ void lambda$run$6(Map map, java.util.function.Supplier supplier, ResourceManager manager, String p_267108_, ResourceLocation p_266969_) {
        map.put(p_267108_, Suppliers.memoize(() -> BlueprintPalettedPermutations.lambda$run$5((java.util.function.Supplier)supplier, manager, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$5(java.util.function.Supplier supplier, ResourceManager manager, ResourceLocation p_266969_) {
        return BlueprintPalettedPermutations.createPaletteMapping((int[])supplier.get(), BlueprintPalettedPermutations.loadPaletteEntryFromImage(manager, p_266969_));
    }

    private record PalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> palette, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        public void discard() {
            this.baseImage.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
            try {
                NativeImage nativeimage = this.baseImage.get().mappedCopy(this.palette.get());
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize(nativeimage.getWidth(), nativeimage.getHeight()), nativeimage, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException ioexception) {
                LOGGER.error("unable to apply palette to {}", (Object)this.permutationLocation, (Object)ioexception);
            }
            finally {
                this.baseImage.release();
            }
            return null;
        }
    }
}

