/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Codecs {
    public static <E extends Enum<E>> Codec<E> forEnum(Class<E> enumClass) {
        return Codec.STRING.comapFlatMap(str -> {
            try {
                return DataResult.success(Enum.valueOf(enumClass, str.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                return DataResult.error(() -> "Unknown " + enumClass.getSimpleName() + ": " + str + ", must be one of: " + Arrays.toString(enumClass.getEnumConstants()));
            }
        }, rotMir -> rotMir.name().toLowerCase(Locale.ROOT));
    }

    public static <T> Codec<T[]> forArray(Codec<T> elementCodec, IntFunction<T[]> arrayFactory) {
        return Codecs.forArray(elementCodec, arrayFactory, Integer.MAX_VALUE);
    }

    public static <T> Codec<T[]> forArray(Codec<T> elementCodec, IntFunction<T[]> arrayFactory, int maxSize) {
        return Codec.list(elementCodec, (int)0, (int)maxSize).xmap(list -> list.toArray(arrayFactory), Arrays::asList);
    }

    public static <T, B extends ByteBuf> StreamCodec<B, T[]> streamForArray(StreamCodec<B, T> elementCodec, IntFunction<T[]> arrayFactory) {
        return Codecs.streamForArray(null, arrayFactory, Integer.MAX_VALUE);
    }

    public static <T, B extends ByteBuf> StreamCodec<B, T[]> streamForArray(final StreamCodec<B, T> elementCodec, final IntFunction<T[]> arrayFactory, final int maxSize) {
        return new StreamCodec<B, T[]>(){

            public T[] decode(B buf) {
                Object[] data = (Object[])arrayFactory.apply(ByteBufCodecs.readCount(buf, (int)maxSize));
                for (int i = 0; i < data.length; ++i) {
                    data[i] = elementCodec.decode(buf);
                }
                return data;
            }

            public void encode(B buf, T[] data) {
                ByteBufCodecs.writeCount(buf, (int)data.length, (int)maxSize);
                for (Object element : data) {
                    elementCodec.encode(buf, element);
                }
            }
        };
    }

    public static <A> Codec<A> withEmpty(final Codec<A> elementCodec, final A emptyInstance) {
        return new Codec<A>(){

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                if (input == emptyInstance) {
                    if (ops.empty() == NbtOps.INSTANCE.empty()) {
                        return DataResult.success((Object)ops.createBoolean(true));
                    }
                    return DataResult.success((Object)ops.empty());
                }
                return elementCodec.encode(input, ops, prefix);
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                if (input == ops.empty() || ops.empty() == NbtOps.INSTANCE.empty() && ops.getBooleanValue(input).result().orElse(false).booleanValue()) {
                    return DataResult.success((Object)new Pair(emptyInstance, input));
                }
                return elementCodec.decode(ops, input);
            }
        };
    }

    public static <A, B extends ByteBuf> StreamCodec<B, A> streamWithEmpty(final StreamCodec<B, A> elementCodec, final A emptyInstance) {
        return new StreamCodec<B, A>(){

            public A decode(B buf) {
                boolean isEmpty = buf.readBoolean();
                return isEmpty ? emptyInstance : elementCodec.decode(buf);
            }

            public void encode(B buf, A data) {
                boolean isEmpty = data == emptyInstance;
                buf.writeBoolean(isEmpty);
                if (!isEmpty) {
                    elementCodec.encode(buf, data);
                }
            }
        };
    }

    public static <A, B extends ByteBuf> StreamCodec<B, A> wrapNullable(StreamCodec<B, A> elementCodec) {
        return (StreamCodec)Util.memoize(s -> Codecs.streamWithEmpty(s, null)).apply(elementCodec);
    }

    public static <O, C> RecordCodecBuilder<O, Optional<C>> wrapNullableField(Codec<C> elementCodec, String fieldName, Function<O, C> fieldGetter) {
        return elementCodec.optionalFieldOf(fieldName).forGetter(fieldGetter.andThen(Optional::ofNullable));
    }
}

