/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.mod.item.BlockStateRenderingData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ItemIconWithBlockState
extends ItemIcon {
    public static final String PARAM_NBT = "nbt";
    @Nullable
    protected BlockStateRenderingData blockStateExtension = null;
    protected boolean renderItemAlongBlockState = false;
    protected boolean isBlockStateModelEmpty = false;
    protected boolean alwaysAddBlockStateTooltip = false;

    public ItemIconWithBlockState() {
    }

    public ItemIconWithBlockState(PaneParams params) {
        super(params);
        ItemStack newItemStack = this.itemStack;
        if (newItemStack != null) {
            String nbt = params.getString(PARAM_NBT);
            if (nbt != null) {
                try {
                    newItemStack.applyComponents((DataComponentMap)((Pair)DataComponentMap.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)TagParser.parseTag((String)nbt)).getOrThrow()).getFirst());
                }
                catch (CommandSyntaxException | IllegalStateException e) {
                    Log.getLogger().error("Cannot parse item nbt", e);
                }
            }
            this.setItem(newItemStack);
        }
        this.alwaysAddBlockStateTooltip = params.getBoolean("alwaysAddBlockStateTooltip", this.alwaysAddBlockStateTooltip);
    }

    @Override
    public void setItem(ItemStack itemStack) {
        super.setItem(itemStack);
        this.readBlockStateFromCurrentItemStack();
    }

    @Override
    public void clearDataAndScheduleTooltipUpdate() {
        super.clearDataAndScheduleTooltipUpdate();
        this.blockStateExtension = null;
        this.renderItemAlongBlockState = false;
        this.isBlockStateModelEmpty = false;
    }

    public boolean isBlockEmpty() {
        return this.blockStateExtension == null || this.isBlockStateModelEmpty;
    }

    @Override
    public boolean isDataEmpty() {
        return super.isDataEmpty() && this.isBlockEmpty();
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        this.updateTooltipIfNeeded();
        if (this.isBlockEmpty()) {
            super.drawSelf(target, mx, my);
            return;
        }
        PoseStack ms = target.pose();
        ms.pushPose();
        ms.translate((float)this.x, (float)this.y, 0.0f);
        ms.scale((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
        if (this.renderItemAlongBlockState) {
            target.renderItem(this.itemStack, 0, 0);
        }
        target.renderBlockStateAsItem(this.blockStateExtension, this.itemStack);
        if (this.renderItemDecorations) {
            target.renderItemDecorations(this.itemStack, 0, 0);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        ms.popPose();
    }

    @Override
    protected int modifyTooltipName(List<Component> tooltipList, TooltipFlag tooltipFlag, int nameOffset) {
        if (this.blockStateExtension != null) {
            ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)this.blockStateExtension.blockState().getBlock());
            String nameTKey = Util.makeDescriptionId((String)"block", (ResourceLocation)key);
            MutableComponent name = Component.translatable((String)nameTKey);
            MutableComponent nameKey = Component.literal((String)key.toString()).withStyle(ChatFormatting.DARK_GRAY);
            if (!tooltipList.get(0).getString().equals(name.getString()) && !name.getString().equals(nameTKey)) {
                tooltipList.add(nameOffset, (Component)name.withStyle(ChatFormatting.GRAY));
                ++nameOffset;
            }
            for (int i = tooltipList.size() - 1; i >= 0; --i) {
                PlainTextContents.LiteralContents literalContents;
                ComponentContents componentContents = tooltipList.get(i).getContents();
                if (!(componentContents instanceof PlainTextContents.LiteralContents) || ResourceLocation.tryParse((String)(literalContents = (PlainTextContents.LiteralContents)componentContents).text()) == null) continue;
                tooltipList.set(i, (Component)nameKey);
                break;
            }
        }
        return nameOffset;
    }

    @Override
    protected int appendTooltip(List<Component> tooltipList, TooltipFlag tooltipFlag, int prevTooltipSize) {
        if (this.blockStateExtension != null && !this.blockStateExtension.blockState().getProperties().isEmpty() && (tooltipFlag.isAdvanced() || this.alwaysAddBlockStateTooltip)) {
            boolean shouldFixPrevTooltipSize = this.alwaysAddBlockStateTooltip && prevTooltipSize == tooltipList.size();
            tooltipList.add((Component)ItemIconWithBlockState.wrapShift(Component.empty(), !this.alwaysAddBlockStateTooltip));
            tooltipList.add((Component)ItemIconWithBlockState.wrapShift(Component.translatable((String)"blockui.tooltip.properties"), !this.alwaysAddBlockStateTooltip));
            BlockState blockState = this.blockStateExtension.blockState();
            for (Property property : blockState.getProperties()) {
                tooltipList.add((Component)ItemIconWithBlockState.wrapShift(Component.literal((String)("  " + property.getName() + " = " + ItemIconWithBlockState.getValueName(blockState, property))).withStyle(ChatFormatting.GRAY), !this.alwaysAddBlockStateTooltip));
            }
            if (shouldFixPrevTooltipSize) {
                prevTooltipSize = tooltipList.size();
            }
        }
        return prevTooltipSize;
    }

    public void setRenderItemAlongBlockState(boolean alwaysRenderItem) {
        this.renderItemAlongBlockState = alwaysRenderItem;
    }

    public boolean shouldRenderItemAlongBlockState() {
        return this.renderItemAlongBlockState;
    }

    public void setAlwaysAddBlockStateTooltip(boolean alwaysAddTooltip) {
        this.alwaysAddBlockStateTooltip = alwaysAddTooltip;
    }

    public boolean shouldAlwaysAddBlockStateTooltip() {
        return this.alwaysAddBlockStateTooltip;
    }

    public void setBlockState(BlockStateRenderingData blockStateExtension) {
        this.setItemFromBlockState(blockStateExtension);
        this.setBlockStateWeak(blockStateExtension);
    }

    public void setBlockStateWeak(BlockStateRenderingData blockStateExtension) {
        ItemStack keepItemStack = Objects.requireNonNull(this.itemStack, "ItemStack must not be null when setting blockState");
        this.clearDataAndScheduleTooltipUpdate();
        this.itemStack = keepItemStack;
        this.blockStateExtension = blockStateExtension;
        BlockState bs = blockStateExtension.blockState();
        if (bs.getRenderShape() == RenderShape.INVISIBLE && blockStateExtension.blockEntity() == null) {
            if (bs.getFluidState().isEmpty()) {
                this.isBlockStateModelEmpty = true;
            } else if (bs.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                this.renderItemAlongBlockState = true;
            }
        }
    }

    public BlockStateRenderingData getBlockState() {
        return this.blockStateExtension;
    }

    protected void readBlockStateFromCurrentItemStack() {
        Item item;
        if (this.itemStack == null || !((item = this.itemStack.getItem()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState blockstate = blockItem.getBlock().defaultBlockState();
        BlockItemStateProperties blockStateTag = (BlockItemStateProperties)this.itemStack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        if (!blockStateTag.isEmpty()) {
            blockstate = blockStateTag.apply(blockstate);
        }
        CompoundTag blockEntityTag = ((CustomData)this.itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        BlockEntity be = null;
        if (!blockEntityTag.isEmpty()) {
            try {
                be = BlockEntity.loadStatic((BlockPos)BlockStateRenderingData.ILLEGAL_BLOCK_ENTITY_POS, (BlockState)blockstate, (CompoundTag)blockEntityTag, (HolderLookup.Provider)this.mc.level.registryAccess());
            }
            catch (Exception e) {
                Log.getLogger().warn("Error while parsing blockentity data: " + String.valueOf(blockEntityTag), (Throwable)e);
            }
        }
        this.setBlockStateWeak(BlockStateRenderingData.of(blockstate, be));
    }

    private static <T extends Comparable<T>> String getValueName(BlockState blockState, Property<T> property) {
        return property.getName(blockState.getValue(property));
    }
}

