/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.mod.item.BlockStateRenderingData;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends Pane {
    protected static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    protected static final MutableComponent FIX_VANILLA_TOOLTIP = SpacerTextComponent.of(1);
    @Nullable
    protected ItemStack itemStack;
    protected boolean tooltipUpdateScheduled = false;
    protected boolean renderItemDecorations = true;

    public ItemIcon() {
    }

    public ItemIcon(PaneParams params) {
        super(params);
        Item item;
        ResourceLocation itemName = params.getResource("item");
        if (itemName != null && (item = (Item)BuiltInRegistries.ITEM.get(itemName)) != null) {
            this.setItem(item.getDefaultInstance());
        }
        this.renderItemDecorations = params.getBoolean("renderItemDecorations", this.renderItemDecorations);
    }

    public void setItem(ItemStack itemStack) {
        this.clearDataAndScheduleTooltipUpdate();
        this.itemStack = itemStack;
        this.onItemUpdate();
    }

    protected void onItemUpdate() {
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public void setRenderItemDecorations(boolean renderDecorations) {
        this.renderItemDecorations = renderDecorations;
    }

    public boolean renderItemDecorations() {
        return this.renderItemDecorations;
    }

    public void setItemFromBlockState(BlockStateRenderingData blockStateExtension) {
        this.clearDataAndScheduleTooltipUpdate();
        this.itemStack = blockStateExtension.itemStack();
        if (this.itemStack.isEmpty() && !(blockStateExtension.blockState().getBlock() instanceof AirBlock)) {
            Log.getLogger().warn("Cannot create proper itemStack for: " + blockStateExtension.blockState().toString());
        }
        if (!this.itemStack.isEmpty() && blockStateExtension.blockEntity() != null) {
            blockStateExtension.blockEntity().saveToItem(this.itemStack, (HolderLookup.Provider)this.mc.level.registryAccess());
        }
        this.onItemUpdate();
    }

    public void clearDataAndScheduleTooltipUpdate() {
        this.itemStack = null;
        this.tooltipUpdateScheduled = true;
    }

    protected boolean isItemEmpty() {
        return this.itemStack == null || this.itemStack.isEmpty();
    }

    public boolean isDataEmpty() {
        return this.isItemEmpty();
    }

    protected void updateTooltipIfNeeded() {
        if (this.tooltipUpdateScheduled) {
            Pane pane = this.onHover;
            if (pane instanceof Tooltip.AutomaticTooltip) {
                Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
                tooltip.setTextOld(this.getModifiedItemStackTooltip());
            }
            this.tooltipUpdateScheduled = false;
        }
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        this.updateTooltipIfNeeded();
        if (!this.isDataEmpty()) {
            PoseStack ms = target.pose();
            ms.pushPose();
            ms.translate((float)this.x, (float)this.y, 0.0f);
            ms.scale((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
            ms.last().normal().identity();
            target.renderItem(this.itemStack, 0, 0);
            if (this.renderItemDecorations) {
                target.renderItemDecorations(this.itemStack, 0, 0);
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            ms.popPose();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && !this.isItemEmpty()) {
            new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane(this).build();
            this.tooltipUpdateScheduled = true;
        }
    }

    protected int modifyTooltipName(List<Component> tooltipList, TooltipFlag tooltipFlags, int nameOffset) {
        return nameOffset;
    }

    protected int appendTooltip(List<Component> tooltipList, TooltipFlag tooltipFlags, int prevTooltipSize) {
        return prevTooltipSize;
    }

    public List<Component> getModifiedItemStackTooltip() {
        TooltipFlag.Default tooltipFlags;
        if (this.isDataEmpty()) {
            return Collections.emptyList();
        }
        TooltipFlag.Default default_ = tooltipFlags = this.mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        if (this.mc.player.isCreative()) {
            tooltipFlags = tooltipFlags.asCreative();
        }
        List tooltipList = this.itemStack.getTooltipLines(Item.TooltipContext.of((Level)this.mc.level), (Player)this.mc.player, (TooltipFlag)tooltipFlags);
        int nameOffset = 1;
        nameOffset = this.modifyTooltipName(tooltipList, (TooltipFlag)tooltipFlags, nameOffset);
        int prevTooltipSize = tooltipList.size();
        if (tooltipFlags.advanced() && tooltipFlags.creative()) {
            int nameoffset = nameOffset + 1;
            BuiltInRegistries.ITEM.wrapAsHolder((Object)this.itemStack.getItem()).tags().forEach(tag -> tooltipList.add(nameoffset, ItemIcon.wrapShift(Component.literal((String)("#" + String.valueOf(tag.location()))).withStyle(ChatFormatting.DARK_PURPLE))));
            int i = nameOffset + 1;
            ItemStack defaultStack = this.itemStack.getItem().getDefaultInstance();
            for (CreativeModeTab tab : CreativeModeTabRegistry.getSortedCreativeModeTabs()) {
                if (!tab.contains(defaultStack)) continue;
                tooltipList.add(i++, ItemIcon.wrapShift(tab.getDisplayName().copy().withStyle(ChatFormatting.BLUE)));
            }
        }
        if ((prevTooltipSize = this.appendTooltip(tooltipList, (TooltipFlag)tooltipFlags, prevTooltipSize)) != tooltipList.size()) {
            tooltipList.add(ToggleableTextComponent.ofNegated(Screen::hasShiftDown, Component.empty()));
            tooltipList.add(ToggleableTextComponent.ofNegated(Screen::hasShiftDown, Component.translatable((String)"blockui.tooltip.item_additional_info", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.shift")}).withStyle(ChatFormatting.GOLD)));
        }
        tooltipList.add(nameOffset, FIX_VANILLA_TOOLTIP);
        return tooltipList;
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped) {
        return ToggleableTextComponent.of(Screen::hasShiftDown, wrapped);
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped, boolean shouldWrap) {
        return shouldWrap ? ToggleableTextComponent.of(Screen::hasShiftDown, wrapped) : wrapped;
    }
}

