/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.gen;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import noobanidus.mods.lootr.common.api.LootrAPI;

public class LootrDataPackGenerators {
    private static final int STRUCTURE_SALT = 8266497;
    private static final ResourceKey<Structure> LOOTR_TEST_STRUCTURE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)LootrAPI.rl("test"));
    private static final ResourceKey<StructureTemplatePool> LOOTR_TEST_START_POOL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)LootrAPI.rl("test_start_pool"));
    private static final ResourceKey<StructureSet> LOOTR_TEST_STRUCTURE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)LootrAPI.rl("test_structure_set"));

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        if (!event.getMods().contains("lootr")) {
            return;
        }
        event.getGenerator().addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), new RegistrySetBuilder().add(Registries.TEMPLATE_POOL, bootstrap -> {
            HolderGetter getter = bootstrap.lookup(Registries.TEMPLATE_POOL);
            Holder.Reference holder = getter.getOrThrow(Pools.EMPTY);
            bootstrap.register(LOOTR_TEST_START_POOL, (Object)new StructureTemplatePool((Holder)holder, List.of(Pair.of((Object)StructurePoolElement.single((String)LootrAPI.rl("test").toString()), (Object)1)), StructureTemplatePool.Projection.RIGID));
        }).add(Registries.STRUCTURE, bootstrap -> {
            HolderGetter biomeGetter = bootstrap.lookup(Registries.BIOME);
            HolderGetter poolGetter = bootstrap.lookup(Registries.TEMPLATE_POOL);
            bootstrap.register(LOOTR_TEST_STRUCTURE, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(BiomeTags.HAS_BURIED_TREASURE), Collections.emptyMap(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX), (Holder)poolGetter.getOrThrow(LOOTR_TEST_START_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80, Collections.emptyList(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        }).add(Registries.STRUCTURE_SET, bootstrap -> {
            HolderGetter structureGetter = bootstrap.lookup(Registries.STRUCTURE);
            bootstrap.register(LOOTR_TEST_STRUCTURE_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(LOOTR_TEST_STRUCTURE), (StructurePlacement)new RandomSpreadStructurePlacement(15, 2, RandomSpreadType.LINEAR, 8266497)));
        }), Set.of("lootr")));
    }
}

