/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.event;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrConstants;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.adapter.ILootrDataAdapter;
import noobanidus.mods.lootr.common.api.adapter.ILootrItemFrameAdapter;
import noobanidus.mods.lootr.common.api.data.entity.ILootrEntity;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.common.entity.LootrItemFrame;

@EventBusSubscriber(modid="lootr")
public class HandleCart {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return;
        }
        if (LootrAPI.isDimensionBlocked((ResourceKey<Level>)level.dimension()) || LootrAPI.isDisabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (LootrAPI.shouldConvertStructureItemFrames() && entity.getType().is(LootrTags.Entity.CONVERT_ITEM_FRAMES) && entity.getTags().contains(LootrConstants.CAN_CONVERT_TAG)) {
            ItemStack contained;
            ILootrItemFrameAdapter<Entity> adapter = LootrAPI.getItemFrameAdapter(entity);
            if (adapter == null) {
                LootrAPI.LOG.error("No item frame adapter found for entity '{}' even though it is tagged for conversion.", (Object)entity);
                return;
            }
            if (!(adapter.isFixed(entity) || adapter.isInvisible(entity) || (contained = adapter.getItem(entity)).isEmpty() || contained.is(LootrTags.Items.ITEM_FRAME_CONVERT_BLACKLIST))) {
                LootrItemFrame newItemFrame = new LootrItemFrame((Level)level.getLevel(), adapter.getPos(entity), adapter.getDirection(entity));
                newItemFrame.lootrSetItem(contained);
                PlatformAPI.copyEntityData(adapter, entity, (ILootrEntity)newItemFrame);
                event.setCanceled(true);
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                executor.tell((Runnable)new TickTask(0, () -> event.getLevel().addFreshEntity((Entity)newItemFrame)));
            }
        } else if (entity.getType().is(LootrTags.Entity.CONVERT_ENTITIES)) {
            ILootrDataAdapter<Entity> adapter = LootrAPI.getAdapter(entity);
            if (adapter == null) {
                LootrAPI.LOG.error("No adapter found for entity '{}' even though it is tagged for conversion.", (Object)entity);
                return;
            }
            ResourceKey<LootTable> lootTable = adapter.getLootTable(entity);
            if (lootTable == null || LootrAPI.isLootTableBlacklisted(lootTable)) {
                return;
            }
            long seed = adapter.getLootSeed(entity);
            LootrAPI.preProcess(level, entity, lootTable, seed);
            LootrChestMinecartEntity lootrCart = new LootrChestMinecartEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ());
            PlatformAPI.copyEntityData(adapter, entity, (ILootrEntity)lootrCart);
            event.setCanceled(true);
            LootrAPI.postProcess(level, (Entity)lootrCart, lootTable, seed);
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            executor.tell((Runnable)new TickTask(0, () -> event.getLevel().addFreshEntity((Entity)lootrCart)));
        }
    }
}

