/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType attributeType, ValueType valueType, boolean booleanValue, int integerValue, String stringValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_display_attribute");
    public static final CustomPacketPayload.Type<ChangeDisplayAttributeMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeDisplayAttributeMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeDisplayAttributeMessage::create);

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType attributeType, Boolean value) {
        this(uuid, attributeType, ValueType.BOOLEAN, value, 0, "");
    }

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType attributeType, Integer value) {
        this(uuid, attributeType, ValueType.INTEGER, false, value, "");
    }

    public static ChangeDisplayAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeDisplayAttributeMessage(buffer.readUUID(), (DisplayAttributeType)buffer.readEnum(DisplayAttributeType.class), (ValueType)buffer.readEnum(ValueType.class), buffer.readBoolean(), buffer.readInt(), buffer.readUtf());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.attributeType);
        buffer.writeEnum((Enum)this.valueType);
        buffer.writeBoolean(this.booleanValue);
        buffer.writeInt(this.integerValue);
        buffer.writeUtf(this.stringValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.valueType) {
            case BOOLEAN: {
                AttributeHandler.setDisplayAttribute((EasyNPC)easyNPC, (DisplayAttributeType)this.attributeType, (Object)this.booleanValue);
                break;
            }
            case INTEGER: {
                AttributeHandler.setDisplayAttribute((EasyNPC)easyNPC, (DisplayAttributeType)this.attributeType, (Object)this.integerValue);
                break;
            }
            case STRING: {
                AttributeHandler.setDisplayAttribute((EasyNPC)easyNPC, (DisplayAttributeType)this.attributeType, (Object)this.stringValue);
                break;
            }
            default: {
                log.error("Invalid display value type {} for {} from {}", (Object)this.valueType, (Object)easyNPC, (Object)serverPlayer);
            }
        }
    }
}

