/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.configuration.equipment.slot;

import com.mojang.datafixers.util.Pair;
import de.markusbordihn.easynpc.configui.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ArmorSlot
extends Slot {
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public final int slotIndex;
    final EquipmentSlot equipmentSlot;
    final EquipmentConfigurationMenu menu;

    public ArmorSlot(EquipmentConfigurationMenu menu, Container container, int slotIndex, int x, int y) {
        super(container, slotIndex, x, y);
        this.slotIndex = slotIndex;
        this.menu = menu;
        this.equipmentSlot = SLOT_IDS[slotIndex];
    }

    public void set(ItemStack itemStack) {
        super.set(itemStack);
        this.menu.setArmorChanged(this.equipmentSlot, this.slotIndex, itemStack);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean mayPlace(ItemStack itemStack) {
        EasyNPC<?> easyNPC = this.menu.getEasyNPC();
        return easyNPC != null && this.equipmentSlot == easyNPC.getLivingEntity().getEquipmentSlotForItem(itemStack);
    }

    public boolean mayPickup(Player player) {
        ItemStack itemStack = this.getItem();
        return !itemStack.isEmpty() && (player.isCreative() || !EnchantmentHelper.hasTag((ItemStack)itemStack, (TagKey)EnchantmentTags.CURSE)) && super.mayPickup(player);
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[this.equipmentSlot.getIndex()]);
    }
}

