/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.gametest;

import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenuHandler;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.gametest.GameTestHelpers;
import java.util.UUID;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.Vec3;

public class EditorScreenTestHelper {
    private EditorScreenTestHelper() {
    }

    public static UUID mockOpenEditorScreen(ServerPlayer serverPlayer, EditorType editorType, EasyNPC<?> easyNPC, MenuType<? extends EditorMenu> menuType) {
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData != null) {
            DialogDataSet dialogDataSet = DialogUtils.getBasicDialog((String)"Test Dialog");
            dialogData.setDialogDataSet(dialogDataSet);
        }
        MenuProvider menuProvider = EditorMenuHandler.getMenuProvider(editorType, easyNPC, menuType, EditorMenuHandler.getScreenData(editorType, easyNPC, dialogData.getDialogDataSet().getDialogsByLabel().stream().findFirst().map(DialogDataEntry::getId).orElse(null), null, null, null, 0, new CompoundTag()));
        UUID menuId = MenuManager.registerMenu(easyNPC.getEntityUUID(), menuProvider, serverPlayer);
        MenuManager.openMenu(menuId, serverPlayer);
        return menuId;
    }

    public static void testEditorScreen(GameTestHelper helper, EntityType<? extends PathfinderMob> npcEntityType, EditorType editorType, MenuType<? extends EditorMenu> menuType) {
        ServerPlayer serverPlayer = GameTestHelpers.mockServerPlayer((GameTestHelper)helper, (Vec3)new Vec3(1.0, 2.0, 1.0));
        EasyNPC easyNPC = GameTestHelpers.mockEasyNPC((GameTestHelper)helper, npcEntityType, (Vec3)new Vec3(2.0, 2.0, 2.0));
        if (serverPlayer.hasContainerOpen()) {
            serverPlayer.closeContainer();
        }
        UUID dialogId = EditorScreenTestHelper.mockOpenEditorScreen(serverPlayer, editorType, easyNPC, menuType);
        GameTestHelpers.assertNotNull((GameTestHelper)helper, (String)"DialogId is null!", (Object)dialogId);
        GameTestHelpers.assertTrue((GameTestHelper)helper, (String)("Editor Screen " + String.valueOf(menuType) + " is not open!"), (boolean)(serverPlayer.containerMenu instanceof EditorMenu));
        GameTestHelpers.assertEquals((GameTestHelper)helper, (String)("Wrong Editor type! Expected: " + String.valueOf(menuType) + " but got: " + String.valueOf(serverPlayer.containerMenu.getType())), menuType, (Object)serverPlayer.containerMenu.getType());
    }
}

