/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition;

import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class ConditionDataListEntry
extends ObjectSelectionList.Entry<ConditionDataListEntry> {
    public static final int ID_LEFT_POS = 0;
    public static final int TYPE_LEFT_POS = 22;
    public static final int VALUE_LEFT_POS = 110;
    public static final int OPTIONS_LEFT_POS = 250;
    private static final int ENTRY_HEIGHT = 21;
    private static final int FIELD_LEFT_OFFSET = 5;
    private static final int FIELD_TOP_OFFSET = 5;
    private static final int COLUMN_SEPARATOR_WIDTH = 1;
    private static final int COLUMN_SEPARATOR_OFFSET = 3;
    private static final int BUTTON_SPACING = 2;
    private static final int BUTTON_SIZE = 18;
    private static final int VALUE_MAX_LENGTH = 21;
    private static final int LIST_WIDTH = 309;
    private static final int COLOR_SEPARATOR_LINE = -5592406;
    private static final int COLOR_COLUMN_SEPARATOR = -10066330;
    private final Font font;
    private final int leftPos;
    private final int topPos;
    private final ConditionDataEntry conditionDataEntry;
    private final ConditionType conditionType;
    private final EditButton editButton;
    private final DeleteButton deleteButton;

    public ConditionDataListEntry(Minecraft minecraft, ConditionDataEntry conditionDataEntry, int leftPos, int topPos, OnEdit onEdit, OnRemove onRemove) {
        this.font = minecraft.font;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.conditionDataEntry = conditionDataEntry;
        this.conditionType = conditionDataEntry != null ? conditionDataEntry.conditionType() : ConditionType.NONE;
        this.editButton = new EditButton(this.leftPos + 250 + 4, this.topPos, 18, 18, onPress -> {
            if (onEdit != null) {
                onEdit.edit(conditionDataEntry);
            }
        });
        this.deleteButton = new DeleteButton(this.editButton.getX() + this.editButton.getWidth() + 2, this.topPos, onPress -> {
            if (onRemove != null) {
                onRemove.remove(conditionDataEntry);
            }
        });
    }

    public Component getNarration() {
        return TextComponent.getText((String)(this.conditionType.name() + ":" + this.conditionDataEntry.name()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        this.editButton.mouseClicked(mouseX, mouseY, button);
        this.deleteButton.mouseClicked(mouseX, mouseY, button);
        return button == 0;
    }

    public void render(GuiGraphics guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        guiGraphics.fill(this.leftPos, top + entryHeight + 2, this.leftPos + 309, top + entryHeight + 3, -5592406);
        int fieldsLeft = this.leftPos + 5;
        int fieldTop = top + 5;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)String.valueOf(entryId), (int)(fieldsLeft + 0 + 2), (int)fieldTop, (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)("conditionType." + this.conditionType.name().toLowerCase()), (int)(fieldsLeft + 22 + 2), (int)fieldTop, (int)0);
        this.renderValuePreview(guiGraphics, fieldsLeft, fieldTop);
        this.editButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.editButton.setY(top);
        this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.deleteButton.setY(top);
        this.renderSeparatorLines(guiGraphics, top);
    }

    private void renderValuePreview(GuiGraphics guiGraphics, int fieldsLeft, int fieldTop) {
        String valuePreview = switch (this.conditionType) {
            case ConditionType.SCOREBOARD -> TextUtils.limitString((String)(this.conditionDataEntry.name() + " " + this.conditionDataEntry.operationType().name() + " " + this.conditionDataEntry.value()), (int)21);
            case ConditionType.EXECUTION_LIMIT -> TextUtils.limitString((String)(this.conditionDataEntry.value() + " (" + this.conditionDataEntry.text() + ")"), (int)21);
            default -> "-";
        };
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)valuePreview, (int)(fieldsLeft + 110 + 2), (int)fieldTop, (int)0);
    }

    public void renderSeparatorLines(GuiGraphics guiGraphics, int top) {
        int separatorTop = top - 1;
        int separatorLeft = this.leftPos + 5;
        guiGraphics.fill(separatorLeft + 22 - 3, separatorTop, separatorLeft + 22 - 3 + 1, separatorTop + 21, -10066330);
        guiGraphics.fill(separatorLeft + 110 - 3, separatorTop, separatorLeft + 110 - 3 + 1, separatorTop + 21, -10066330);
        guiGraphics.fill(separatorLeft + 250 - 3, separatorTop, separatorLeft + 250 - 3 + 1, separatorTop + 21, -10066330);
    }

    public static interface OnEdit {
        public void edit(ConditionDataEntry var1);
    }

    public static interface OnRemove {
        public void remove(ConditionDataEntry var1);
    }
}

