/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.ConditionDataList;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ConditionDataEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int HOME_BUTTON_X_OFFSET = 3;
    private static final int HOME_BUTTON_Y_OFFSET = 3;
    private static final int HOME_BUTTON_WIDTH = 10;
    private static final int HOME_BUTTON_HEIGHT = 16;
    private static final int NAVIGATION_BUTTON_WIDTH = 140;
    private static final int LIST_X_OFFSET = 5;
    private static final int LIST_Y_START = 40;
    private static final int LIST_Y_END = 200;
    private static final int LIST_TOTAL_WIDTH = 314;
    private static final int HEADER_Y_OFFSET = 25;
    private static final int HEADER_HEIGHT = 18;
    private static final int ENTRY_HEIGHT = 21;
    private static final int FOOTER_Y_OFFSET = 210;
    private static final int FOOTER_HEIGHT = 31;
    private static final int ADD_BUTTON_X_OFFSET = 7;
    private static final int ADD_BUTTON_WIDTH = 300;
    private static final int COLOR_LIST_BACKGROUND = -1118482;
    private static final int COLOR_HEADER_BACKGROUND = -5592406;
    private static final int COLOR_FOOTER_BACKGROUND = -3750202;
    private static final int COLOR_SEPARATOR = -10066330;
    private final ConditionDataSet conditionDataSet = this.getConditionDataSet();
    protected Button homeButton;
    protected Button dialogButton;
    protected Button conditionsButton;
    protected Button newConditionDataEntryButton;
    ConditionDataList conditionDataList;

    public ConditionDataEditorContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private ConditionDataSet getConditionDataSet() {
        DialogDataEntry dialogData = this.getDialogData();
        if (dialogData != null && dialogData.getConditions() != null) {
            ConditionDataSet conditionDataSet = new ConditionDataSet();
            for (ConditionDataEntry entry : dialogData.getConditions()) {
                conditionDataSet.add(entry);
            }
            return conditionDataSet;
        }
        log.error("No valid condition data set found!");
        return new ConditionDataSet();
    }

    public void init() {
        super.init();
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 16, "<", onPress -> this.handleBackNavigation()));
        this.dialogButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 3, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.conditionsButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.dialogButton.getX() + this.dialogButton.getWidth(), this.topPos + 3, 140, "Conditions", onPress -> {}));
        this.conditionsButton.active = false;
        this.newConditionDataEntryButton = (Button)this.addRenderableWidget((GuiEventListener)new AddButton(this.leftPos + 7, this.topPos + 210, 300, "condition.add", onPress -> this.handleNewConditionDataEntry()));
        this.conditionDataList = new ConditionDataList(this.conditionDataSet, this.minecraft, this.width + 50, this.height - 60, this.leftPos + 5, this.topPos + 40, this.topPos + 200, 21, this::handleEditConditionDataEntry, this::handleDeleteConditionDataEntry);
        this.addWidget((GuiEventListener)this.conditionDataList);
    }

    private void handleBackNavigation() {
        NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
    }

    private void handleNewConditionDataEntry() {
        NetworkMessageHandlerManager.getServerHandler().openConditionDataEntryEditor(this.getEasyNPCUUID(), this.getDialogUUID(), new ConditionDataEntry(ConditionType.SCOREBOARD));
    }

    private void handleDeleteConditionDataEntry(ConditionDataEntry conditionDataEntry) {
        if (this.minecraft == null || this.conditionDataSet == null || conditionDataEntry == null || conditionDataEntry.getId().equals(Constants.EMPTY_UUID)) {
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.conditionDataSet.remove(conditionDataEntry.getId());
                this.updateConditionDataSet();
                this.navigateToConditionDataEditor();
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteWarning", (String)conditionDataEntry.conditionType().name()), (Component)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteButton"), CommonComponents.GUI_CANCEL));
    }

    private void updateConditionDataSet() {
        DialogDataEntry dialogData = this.getDialogData();
        dialogData.setConditions(this.conditionDataSet.getConditions());
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogData);
    }

    private void handleEditConditionDataEntry(ConditionDataEntry conditionDataEntry) {
        log.info("Editing Condition Data Entry {}: {}", (Object)conditionDataEntry.getId(), (Object)conditionDataEntry);
        NetworkMessageHandlerManager.getServerHandler().openConditionDataEntryEditor(this.getEasyNPCUUID(), this.getDialogUUID(), conditionDataEntry);
    }

    private void navigateToConditionDataEditor() {
        NetworkMessageHandlerManager.getServerHandler().openConditionDataEditor(this.getEasyNPCUUID(), this.getDialogUUID());
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        guiGraphics.fill(this.leftPos + 5, this.topPos + 25 + 5, this.leftPos + 314, this.topPos + 200, -1118482);
        if (this.conditionDataList != null) {
            this.conditionDataList.render(guiGraphics, x, y, partialTicks);
        }
        this.renderHeader(guiGraphics);
        this.renderFooter(guiGraphics);
        if (this.newConditionDataEntryButton != null) {
            this.newConditionDataEntryButton.render(guiGraphics, x, y, partialTicks);
        }
    }

    private void renderHeader(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.leftPos + 5, this.topPos + 25, this.leftPos + 314, this.topPos + 25 + 18, -5592406);
        int headerLeft = this.leftPos + 10;
        int headerTop = this.topPos + 25 + 5;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"ID", (int)(headerLeft + 0), (int)headerTop, (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"type", (int)(headerLeft + 22), (int)headerTop, (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"value", (int)(headerLeft + 110), (int)headerTop, (int)0);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Action", (int)(headerLeft + 250), (int)headerTop, (int)0);
        int separatorTop = headerTop - 5;
        guiGraphics.fill(headerLeft + 22 - 3, separatorTop, headerLeft + 22 - 2, separatorTop + 18, -10066330);
        guiGraphics.fill(headerLeft + 110 - 3, separatorTop, headerLeft + 110 - 2, separatorTop + 18, -10066330);
        guiGraphics.fill(headerLeft + 250 - 3, separatorTop, headerLeft + 250 - 2, separatorTop + 18, -10066330);
    }

    private void renderFooter(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.leftPos + 5, this.topPos + 200, this.leftPos + 314, this.topPos + 200 + 31, -3750202);
    }
}

