/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action.entry;

import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.ActionDataEntryEditorContainerScreen;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.entry.ActionEntryWidget;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import java.util.LinkedHashSet;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class OpenNamedDialogEntry
extends ActionEntryWidget {
    private final DialogDataSet dialogDataSet;
    private TextField dialogNameTextField;
    private TextField targetUuidTextField;
    private TargetType targetType;
    private SpinButton<TargetType> targetTypeButton;
    private boolean showInvalidDialogName = false;
    private boolean showInvalidUuid = false;

    public OpenNamedDialogEntry(ActionDataEntry actionDataEntry, ActionDataSet actionDataSet, ActionDataEntryEditorContainerScreen<?> screen) {
        super(actionDataEntry, actionDataSet, screen);
        this.dialogDataSet = screen.getDialogDataSet();
        this.targetType = actionDataEntry.targetUUID() != null ? TargetType.UUID : TargetType.SELF;
    }

    private void validateDialogName(String dialogName) {
        if (dialogName == null || dialogName.isEmpty()) {
            return;
        }
        this.showInvalidDialogName = this.targetType != TargetType.SELF || this.dialogDataSet == null || !this.dialogDataSet.hasDialog(dialogName);
    }

    private void validateUuid(String uuidString) {
        if (uuidString == null || uuidString.isEmpty()) {
            this.showInvalidUuid = false;
            return;
        }
        try {
            UUID.fromString(uuidString);
            this.showInvalidUuid = false;
        }
        catch (IllegalArgumentException e) {
            this.showInvalidUuid = true;
        }
    }

    @Override
    public void init(int editorLeft, int editorTop) {
        boolean hasActionData = this.hasActionData(ActionDataType.OPEN_NAMED_DIALOG);
        this.dialogNameTextField = this.screen.addActionEntryWidget(new TextField(this.font, editorLeft + 1, editorTop + 40, 301, 16));
        this.dialogNameTextField.setMaxLength(512);
        this.dialogNameTextField.setValue(hasActionData ? this.actionDataEntry.command() : "");
        this.dialogNameTextField.setResponder(this::validateDialogName);
        LinkedHashSet<TargetType> targetTypes = new LinkedHashSet<TargetType>();
        targetTypes.add(TargetType.SELF);
        targetTypes.add(TargetType.UUID);
        this.targetTypeButton = this.screen.addActionEntryWidget(new SpinButton(editorLeft, this.dialogNameTextField.getY() + this.dialogNameTextField.getHeight() + 2, 80, 16, targetTypes, (Object)this.targetType, this::onTargetTypeChange));
        this.targetUuidTextField = this.screen.addActionEntryWidget(new TextField(this.font, this.targetTypeButton.getX() + this.targetTypeButton.getWidth() + 2, this.targetTypeButton.getY(), 220, 16));
        this.targetUuidTextField.setMaxLength(36);
        this.targetUuidTextField.setValue(hasActionData && this.actionDataEntry.targetUUID() != null ? this.actionDataEntry.targetUUID().toString() : "");
        this.targetUuidTextField.setResponder(this::validateUuid);
        this.targetUuidTextField.visible = this.targetType == TargetType.UUID;
    }

    private void onTargetTypeChange(SpinButton<?> spinButton) {
        this.targetType = (TargetType)((Object)spinButton.get());
        if (this.targetUuidTextField != null) {
            this.targetUuidTextField.visible = this.targetType == TargetType.UUID;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int editorLeft, int editorTop) {
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"action.named_dialog", (int)(editorLeft + 2), (int)(editorTop + 27), (int)0x404040);
        if (this.showInvalidDialogName && this.targetType == TargetType.SELF) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"action.invalid_dialog_name", (int)(editorLeft + 95), (int)(editorTop + 62), (int)0xFF5555);
        }
        if (this.showInvalidUuid && this.targetType == TargetType.UUID) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"action.invalid_uuid", (int)(editorLeft + 90), (int)(editorTop + 78), (int)0xFF5555);
        }
    }

    @Override
    public ActionDataEntry getActionDataEntry() {
        if (this.targetType == TargetType.UUID && this.targetUuidTextField != null) {
            String uuidString = this.targetUuidTextField.getValue();
            try {
                UUID targetUUID = UUID.fromString(uuidString);
                return new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, targetUUID, this.dialogNameTextField.getValue());
            }
            catch (IllegalArgumentException e) {
                return new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, this.dialogNameTextField.getValue());
            }
        }
        return new ActionDataEntry(ActionDataType.OPEN_NAMED_DIALOG, this.dialogNameTextField.getValue());
    }

    @Override
    public boolean hasChanged() {
        if (this.showInvalidDialogName && this.targetType == TargetType.SELF) {
            return false;
        }
        if (this.showInvalidUuid && this.targetType == TargetType.UUID) {
            return false;
        }
        boolean dialogNameChanged = this.dialogNameTextField != null && !this.dialogNameTextField.getValue().equals(this.actionDataEntry.command());
        boolean targetTypeChanged = this.targetType == TargetType.UUID == (this.actionDataEntry.targetUUID() == null);
        boolean targetUuidChanged = false;
        if (this.targetType == TargetType.UUID && this.targetUuidTextField != null) {
            String currentUuid = this.targetUuidTextField.getValue();
            String originalUuid = this.actionDataEntry.targetUUID() != null ? this.actionDataEntry.targetUUID().toString() : "";
            targetUuidChanged = !currentUuid.equals(originalUuid);
        }
        return dialogNameChanged || targetTypeChanged || targetUuidChanged;
    }

    private static enum TargetType {
        SELF,
        UUID;

    }
}

