/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BasicTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    protected EditBox resetsEveryMinEditBox;
    protected EditBox maxUsesEditBox;
    protected EditBox rewardExpEditBox;

    public BasicTradingConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingResetsEveryMin(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingMaxUses(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onRewardExpEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingRewardExp(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    @Override
    public void init() {
        super.init();
        this.basicTradesButton.active = false;
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        this.resetsEveryMinEditBox = new TextField(this.font, this.contentLeftPos + 166, this.contentTopPos + 142, 32);
        this.resetsEveryMinEditBox.setMaxLength(3);
        this.resetsEveryMinEditBox.setValue("" + tradingDataSet.getResetsEveryMin());
        this.resetsEveryMinEditBox.setResponder(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.setFilter(ValueUtils::isPositiveNumericValueOrZero);
        this.addRenderableWidget((GuiEventListener)this.resetsEveryMinEditBox);
        this.maxUsesEditBox = new PositiveNumberField(this.font, this.contentLeftPos + 166, this.contentTopPos + 165, 32);
        this.maxUsesEditBox.setMaxLength(4);
        this.maxUsesEditBox.setValue("" + tradingDataSet.getMaxUses());
        this.maxUsesEditBox.setResponder(this::onMaxUsesEditBoxChanged);
        this.maxUsesEditBox.setFilter(ValueUtils::isPositiveNumericValueOrZero);
        this.addRenderableWidget((GuiEventListener)this.maxUsesEditBox);
        this.rewardExpEditBox = new TextField(this.font, this.contentLeftPos + 166, this.contentTopPos + 188, 32);
        this.rewardExpEditBox.setMaxLength(3);
        this.rewardExpEditBox.setValue("" + tradingDataSet.getRewardedXP());
        this.rewardExpEditBox.setResponder(this::onRewardExpEditBoxChanged);
        this.rewardExpEditBox.setFilter(ValueUtils::isPositiveNumericValueOrZero);
        this.addRenderableWidget((GuiEventListener)this.rewardExpEditBox);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderTooltip(guiGraphics, x, y);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int slotPositionX = this.leftPos + 30 - 1;
        int slotPositionY = this.topPos + 40 - 1;
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            if (tradingOffer == 6) {
                slotPositionX = this.leftPos + 190 - 1;
                slotPositionY = this.topPos + 40 - 1;
            }
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)((tradingOffer < 9 ? " " : "") + (tradingOffer + 1) + "."), (int)(slotPositionX - 15), (int)(slotPositionY + 5), (int)0x404040);
            int itemASlotLeftPosition = slotPositionX;
            int itemASlotTopPosition = slotPositionY;
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)itemASlotLeftPosition, (int)itemASlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"+", (int)(itemASlotLeftPosition + 18 + 6), (int)(itemASlotTopPosition + 5), (int)0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)itemBSlotLeftPosition, (int)itemBSlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"=", (int)(itemBSlotLeftPosition + 18 + 12), (int)(itemBSlotTopPosition + 5), (int)0x404040);
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(slotPositionX + 82), (int)slotPositionY, (int)7, (int)7, (int)18, (int)18);
            slotPositionY += 19;
        }
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)this.contentLeftPos, (int)(this.contentTopPos + 135), (int)7, (int)83, (int)162, (int)54);
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)this.contentLeftPos, (int)(this.contentTopPos + 191), (int)7, (int)141, (int)162, (int)18);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"trading.minutes_for_trade_reset", (int)(this.contentLeftPos + 202), (int)(this.resetsEveryMinEditBox.getY() + 3), (int)0x404040);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"trading.max_uses_per_trade", (int)(this.contentLeftPos + 202), (int)(this.maxUsesEditBox.getY() + 3), (int)0x404040);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"trading.rewarded_exp_per_trade", (int)(this.contentLeftPos + 202), (int)(this.rewardExpEditBox.getY() + 3), (int)0x404040);
    }
}

