/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured.BWGOverworldConfiguredFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured.BWGOverworldTreeConfiguredFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured.BWGOverworldVegetationConfiguredFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured.BWGVanillaConfiguredFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.configured.ConfiguredFeaturesUtil;

public class BWGConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOSSY_STONE_BOULDER = BWGConfiguredFeatures.createForestRock("mossy_stone_boulder", BWGBlocks.MOSSY_STONE_SET::getBase);
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROCKY_STONE_BOULDER = BWGConfiguredFeatures.createForestRock("rocky_stone_boulder", BWGBlocks.ROCKY_STONE_SET::getBase);
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKSTONE_BOULDER = BWGConfiguredFeatures.createForestRock("blackstone_boulder", () -> Blocks.BLACKSTONE);
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORANGE_TERRACOTTA_BOULDER = BWGConfiguredFeatures.createForestRock("orange_terracotta_boulder", () -> Blocks.ORANGE_TERRACOTTA);
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACK_ICE = ConfiguredFeaturesUtil.createConfiguredFeature("black_ice", Feature.SIMPLE_BLOCK, () -> new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)BWGBlocks.BLACK_ICE.get().defaultBlockState())));
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISK_MUD = ConfiguredFeaturesUtil.createConfiguredFeature("disk_mud", Feature.DISK, () -> new DiskConfiguration(new RuleBasedBlockStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MUD), (List)ImmutableList.of((Object)new RuleBasedBlockStateProvider.Rule(BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.AIR}), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MUD)))), BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.DIRT, Blocks.CLAY}), (IntProvider)UniformInt.of((int)2, (int)6), 2));
    public static final ResourceKey<ConfiguredFeature<?, ?>> BASALT_DELTA = ConfiguredFeaturesUtil.createConfiguredFeature("delta", Feature.DELTA_FEATURE, () -> new DeltaFeatureConfiguration(Blocks.WATER.defaultBlockState(), Blocks.WATER.defaultBlockState(), (IntProvider)UniformInt.of((int)3, (int)4), (IntProvider)UniformInt.of((int)0, (int)2)));
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_BASALT_COLUMN = ConfiguredFeaturesUtil.createConfiguredFeature("small_basalt_columns", Feature.BASALT_COLUMNS, () -> new ColumnFeatureConfiguration((IntProvider)UniformInt.of((int)0, (int)1), (IntProvider)UniformInt.of((int)1, (int)1)));
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_BASALT_COLUMN = ConfiguredFeaturesUtil.createConfiguredFeature("large_basalt_columns", Feature.BASALT_COLUMNS, () -> new ColumnFeatureConfiguration((IntProvider)UniformInt.of((int)1, (int)2), (IntProvider)UniformInt.of((int)1, (int)1)));
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWAMP_GRASS_BLOCK_DELTA = ConfiguredFeaturesUtil.createConfiguredFeature("swamp_grass_block_delta", Feature.DELTA_FEATURE, () -> new DeltaFeatureConfiguration(Blocks.WATER.defaultBlockState(), Blocks.GRASS_BLOCK.defaultBlockState(), (IntProvider)UniformInt.of((int)10, (int)15), (IntProvider)UniformInt.of((int)1, (int)3)));

    private static ResourceKey<ConfiguredFeature<?, ?>> createForestRock(String name, Supplier<? extends Block> block) {
        return ConfiguredFeaturesUtil.createConfiguredFeature(name, Feature.FOREST_ROCK, () -> new BlockStateConfiguration(((Block)block.get()).defaultBlockState()));
    }

    public static void configuredFeatures() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Configured Features");
        BWGOverworldVegetationConfiguredFeatures.init();
        BWGOverworldTreeConfiguredFeatures.init();
        BWGVanillaConfiguredFeatures.init();
        BWGOverworldConfiguredFeatures.init();
    }
}

