/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.world.level.RandomTickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MediumPumpkinFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceKey<Feature<?>> AUTUMNITY_PUMPKIN_FEATURE = ResourceKey.create((ResourceKey)Registries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autumnity", (String)"pumpkin_fields_pumpkin"));

    public MediumPumpkinFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext context) {
        int z;
        int y;
        int x;
        WorldGenLevel level = context.level();
        Holder.Reference featureHolder = level.registryAccess().lookupOrThrow(Registries.FEATURE).get(AUTUMNITY_PUMPKIN_FEATURE).orElse(null);
        if (featureHolder != null) {
            return ((Feature)featureHolder.value()).place(context);
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos origin = context.origin();
        if (level.getLevel().structureManager().hasAnyStructureAt(origin)) {
            return false;
        }
        for (x = 0; x < 2; ++x) {
            for (int z2 = 0; z2 < 2; ++z2) {
                mutable.setWithOffset((Vec3i)origin, x, -1, z2);
                if (level.getBlockState((BlockPos)mutable).canOcclude()) continue;
                return false;
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                for (z = 0; z < 2; ++z) {
                    mutable.setWithOffset((Vec3i)origin, x, y, z);
                    if (!level.getBlockState((BlockPos)mutable).canOcclude()) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                for (z = 0; z < 2; ++z) {
                    ChunkAccess chunk;
                    mutable.setWithOffset((Vec3i)origin, x, y, z);
                    level.setBlock((BlockPos)mutable, Blocks.PUMPKIN.defaultBlockState(), 2);
                    if (y != 0 || !((chunk = level.getChunk((BlockPos)mutable)) instanceof RandomTickScheduler)) continue;
                    RandomTickScheduler randomTickScheduler = (RandomTickScheduler)chunk;
                    randomTickScheduler.scheduleRandomTick((BlockPos)mutable);
                }
            }
        }
        return true;
    }
}

