/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.data.recipe.immersiveengineering;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.allthemods.alltheores.content.blocks.sets.ATOSetHelper;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class ATOIECrusherRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ATOIECrusherRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    private ResourceLocation crusherDir(String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("crusher/" + type));
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ATOSetHelper.applyToAlloy(set -> recipeOutput.accept(this.crusherDir(String.format("%s/from_ingot", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get()), Ingredient.of(set.INGOT_TAG), List.of()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")}));
        ATOSetHelper.applyToIngot(set -> {
            recipeOutput.accept(this.crusherDir(String.format("%s/from_ore", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get(), 2), Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), Stream.of(ATORegistry.getByproducts().containsKey(set.RAW.get()) ? new StackWithChance(new TagOutput((ItemLike)ATORegistry.getByproducts().get((Object)set.RAW.get()).first), ((Float)ATORegistry.getByproducts().get((Object)set.RAW.get()).second).floatValue(), new ICondition[0]) : null).filter(Objects::nonNull).toList()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")});
            recipeOutput.accept(this.crusherDir(String.format("%s/from_raw", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get()), Ingredient.of(set.RAW_TAG), Stream.of(ATORegistry.getByproducts().containsKey(set.RAW.get()) ? new StackWithChance(new TagOutput((ItemLike)ATORegistry.getByproducts().get((Object)set.RAW.get()).first), ((Float)ATORegistry.getByproducts().get((Object)set.RAW.get()).second).floatValue(), new ICondition[0]) : null).filter(Objects::nonNull).toList()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")});
            recipeOutput.accept(this.crusherDir(String.format("%s/from_raw_block", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get(), 12), Ingredient.of(set.RAW_BLOCK_ITEM_TAG), Stream.of(ATORegistry.getByproducts().containsKey(set.RAW.get()) ? new StackWithChance(new TagOutput((ItemLike)ATORegistry.getByproducts().get((Object)set.RAW.get()).first), ((Float)ATORegistry.getByproducts().get((Object)set.RAW.get()).second).floatValue(), new ICondition[0]) : null).filter(Objects::nonNull).toList()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")});
        });
        ATOSetHelper.applyToGem(set -> {
            recipeOutput.accept(this.crusherDir(String.format("%s/from_ore", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.GEM.get(), 6), Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), List.of()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")});
            recipeOutput.accept(this.crusherDir(String.format("%s/from_gem", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get()), Ingredient.of(set.GEM_TAG), List.of(new StackWithChance(new TagOutput((ItemLike)set.DUST.get()), 0.3333f, new ICondition[0]))), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")});
        });
        ATOSetHelper.applyToDust(set -> recipeOutput.accept(this.crusherDir(String.format("%s/from_ore", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get(), 2), Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), List.of()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")}));
        ATOSetHelper.applyToVanillaIngot(set -> recipeOutput.accept(this.crusherDir(String.format("%s/from_ingot", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get()), Ingredient.of(set.INGOT_TAG), List.of()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")}));
        ATOSetHelper.applyToVanillaGem(set -> recipeOutput.accept(this.crusherDir(String.format("%s/from_raw", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get()), Ingredient.of(set.GEM_TAG), List.of(new StackWithChance(new TagOutput((ItemLike)set.DUST.get()), 0.3333f, new ICondition[0]))), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")}));
        ATOSetHelper.applyToVanillaDebris(set -> recipeOutput.accept(this.crusherDir(String.format("%s/from_ingot", set.name)), (Recipe)this.crusherRecipe(new TagOutput((ItemLike)set.DUST.get()), Ingredient.of(set.INGOT_TAG), List.of()), null, new ICondition[]{new ModLoadedCondition("immersiveengineering")}));
    }

    private CrusherRecipe crusherRecipe(TagOutput output, Ingredient input, List<StackWithChance> secondaryOutputs) {
        return new CrusherRecipe(output, input, 51200, secondaryOutputs);
    }
}

