/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.mixin;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.SpawnState.class})
public class MixinEntityDensityManager {
    @Shadow
    @Final
    private Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
    @Shadow
    @Final
    private int spawnableChunkCount;
    @Shadow
    @Final
    private LocalMobCapCalculator localMobCapCalculator;

    @Inject(method={"canSpawnForCategory(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/world/level/ChunkPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifySpawnCapByCategory(MobCategory entityClassification, ChunkPos chunkPos, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel level = this.localMobCapCalculator.chunkMap.level;
        EnhancedCelestials.lunarForecastWorldData((Level)level).ifPresent(data -> {
            int i = (int)((double)entityClassification.getMaxInstancesPerChunk() * ((double)this.spawnableChunkCount * data.currentLunarEvent().getSpawnMultiplierForMonsterCategory(entityClassification)) / (double)NaturalSpawner.MAGIC_NUMBER);
            if (this.mobCategoryCounts.getInt((Object)entityClassification) >= i) {
                cir.setReturnValue((Object)false);
            } else {
                cir.setReturnValue((Object)this.localMobCapCalculator.canSpawn(entityClassification, chunkPos));
            }
        });
    }
}

