/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.level.SyncedLevelTrackedData;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEventProbabilities;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import dev.corgitaco.enhancedcelestials.lunarevent.LunarEventInstance;
import dev.corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnhancedCelestialsLunarForecastWorldData
extends SyncedLevelTrackedData
implements TickableTrackedData {
    protected final List<LunarEventInstance> forecast = new ArrayList<LunarEventInstance>();
    protected final List<LunarEventInstance> pastEvents = new ArrayList<LunarEventInstance>();
    private long lastCheckedDay = -1L;
    private boolean shouldSync = false;
    protected final transient Holder<LunarDimensionSettings> dimensionSettingsHolder;
    protected final transient Map<Holder<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements;
    private transient Holder<LunarEvent> lastTickEvent;
    private transient Holder<LunarEvent> lastStoredEvent;
    protected transient float blend = 1.0f;

    public EnhancedCelestialsLunarForecastWorldData(TrackedDataKey<EnhancedCelestialsLunarForecastWorldData> key, Level level, Holder<LunarDimensionSettings> lunarDimensionSettingsHolder, Map<Holder<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirementsMap) {
        super(key, level);
        this.dimensionSettingsHolder = lunarDimensionSettingsHolder;
        this.lunarEventSpawnRequirements = lunarEventSpawnRequirementsMap;
        this.lastTickEvent = this.currentLunarEventHolder();
        this.lastStoredEvent = this.currentLunarEventHolder();
        String lunarEventNames = Arrays.toString(this.lunarEventSpawnRequirements.keySet().stream().map(Holder::unwrapKey).map(Optional::orElseThrow).map(ResourceKey::location).map(ResourceLocation::toString).toArray());
        String dimension = level.dimension().location().toString();
        EnhancedCelestials.LOGGER.info("Possible lunar events for dimension \"%s\" are %s.".formatted(dimension, lunarEventNames));
    }

    @Nullable
    public CompoundTag save() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("forecast", (Tag)LunarEventInstance.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.forecast).getOrThrow());
        compoundTag.put("pastEvents", (Tag)LunarEventInstance.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.pastEvents).getOrThrow());
        compoundTag.putLong("lastCheckedDay", this.lastCheckedDay);
        return compoundTag;
    }

    public void load(CompoundTag tag) {
        this.forecast.clear();
        this.forecast.addAll((Collection)((Pair)LunarEventInstance.LIST_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("forecast")).getOrThrow()).getFirst());
        this.pastEvents.clear();
        this.pastEvents.addAll((Collection)((Pair)LunarEventInstance.LIST_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("pastEvents")).getOrThrow()).getFirst());
        this.lastCheckedDay = tag.getLong("lastCheckedDay");
    }

    public void readFromNetwork(CompoundTag tag) {
        super.readFromNetwork(tag);
        if (this.lastTickEvent != this.currentLunarEventHolder()) {
            this.eventSwitched(this.lastLunarEventHolder(), this.currentLunarEventHolder());
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            this.serverTick();
        } else {
            this.baseTick();
        }
    }

    private void serverTick() {
        this.removeFromForecastIf(lunarEventInstance -> {
            if (lunarEventInstance.passed(this.getCurrentDay())) {
                this.pastEvents.add(0, (LunarEventInstance)lunarEventInstance);
                return true;
            }
            return lunarEventInstance.scheduledDay() > this.getCurrentDay() + ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).yearLengthInDays();
        });
        this.removeFromPastEventsIf(lunarEventInstance -> lunarEventInstance.scheduledDay() > this.getCurrentDay() || lunarEventInstance.scheduledDay() < this.getCurrentDay() - ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).yearLengthInDays());
        this.baseTick();
        this.createOrUpdateForecast(this.lastCheckedDay);
        this.checkEmptyForecastOrThrow();
        if (this.shouldSync) {
            super.sync();
            this.shouldSync = false;
        }
    }

    private void checkEmptyForecastOrThrow() {
        if (this.forecast.isEmpty() && ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).yearLengthInDays() > ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).maxDaysBetweenEvents()) {
            throw new IllegalStateException("Forecast cannot be empty.... this should be impossible.... crashing game..... Report this to the Enhanced Celestials Github immediately, please provide your current world instance + other mods.");
        }
    }

    private void baseTick() {
        if (this.blend < 1.0f) {
            this.blend += 0.01f;
        }
        if (this.currentLunarEventHolder() != this.lastTickEvent) {
            this.eventSwitched(this.lastTickEvent, this.currentLunarEventHolder());
        }
        this.lastTickEvent = this.level.isNight() ? (this.level.isRaining() && ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).requiresClearSkies() ? this.defaultLunarEvent() : this.currentLunarEventHolder()) : this.defaultLunarEvent();
    }

    public void recomputeForecast() {
        this.checkServer();
        this.clearForecast();
        this.createOrUpdateForecast(this.getCurrentDay());
    }

    private void clearForecast() {
        this.forecast.clear();
        this.markChanged();
    }

    public boolean switchingEvents() {
        return this.blend < 1.0f;
    }

    public void eventSwitched(Holder<LunarEvent> lastEvent, Holder<LunarEvent> nextEvent) {
        this.blend = 0.0f;
        this.lastStoredEvent = lastEvent;
        if (!this.level.isClientSide) {
            this.serverEventSwitched(lastEvent, nextEvent);
        }
    }

    public void setLunarEvent(ResourceKey<LunarEvent> lunarEvent) {
        LunarEventInstance first;
        this.checkServer();
        if (!this.level.isNight()) {
            ((ServerLevel)this.level).setDayTime(this.getCurrentDay() * ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).dayLength() + 13000L);
        }
        if ((first = this.forecast.get(0)).active(this.getCurrentDay())) {
            this.removeEventInForecast(0);
        }
        if (lunarEvent != ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).defaultEvent()) {
            this.addEventToForecast(0, new LunarEventInstance(lunarEvent, this.getCurrentDay(), true));
        }
    }

    private void serverEventSwitched(Holder<LunarEvent> lastEvent, Holder<LunarEvent> nextEvent) {
        this.checkServer();
        for (Player player : this.level.players()) {
            ((LunarEvent)lastEvent.value()).getTextComponents().setNotification().ifPresent(notification -> {
                if (notification.notificationType() != LunarTextComponents.NotificationType.NONE) {
                    player.displayClientMessage(notification.customTranslationTextComponent().getComponent(), notification.notificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                }
            });
            ((LunarEvent)nextEvent.value()).getTextComponents().riseNotification().ifPresent(notification -> {
                if (notification.notificationType() != LunarTextComponents.NotificationType.NONE) {
                    player.displayClientMessage(notification.customTranslationTextComponent().getComponent(), notification.notificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                }
            });
        }
    }

    public LunarEvent lastLunarEvent() {
        return (LunarEvent)this.lastLunarEventHolder().value();
    }

    public Holder<LunarEvent> lastLunarEventHolder() {
        return this.lastStoredEvent;
    }

    public LunarEvent currentLunarEvent() {
        return (LunarEvent)this.currentLunarEventHolder().value();
    }

    public Holder<LunarEvent> currentLunarEventHolder() {
        if (this.level.isDay()) {
            return this.defaultLunarEvent();
        }
        if (((LunarDimensionSettings)this.dimensionSettingsHolder.value()).requiresClearSkies() && this.level.isRaining()) {
            return this.defaultLunarEvent();
        }
        Holder.Reference<LunarEvent> defaultEvent = this.defaultLunarEvent();
        if (this.forecast.isEmpty()) {
            return defaultEvent;
        }
        LunarEventInstance first = this.forecast.get(0);
        if (first.active(this.getCurrentDay())) {
            return this.lunarEventHolder(first.getLunarEventKey());
        }
        return defaultEvent;
    }

    public Holder<LunarEvent> nextScheduledLunarEvent() {
        if (this.forecast.isEmpty()) {
            return this.defaultLunarEvent();
        }
        LunarEventInstance first = this.forecast.get(0);
        if (first.active(this.getCurrentDay())) {
            LunarEventInstance second = this.forecast.get(1);
            return this.lunarEventHolder(second.getLunarEventKey());
        }
        return this.lunarEventHolder(first.getLunarEventKey());
    }

    public Holder<LunarEvent> lastScheduledLunarEvent() {
        Holder.Reference<LunarEvent> defaultEvent = this.defaultLunarEvent();
        if (this.pastEvents.isEmpty()) {
            return defaultEvent;
        }
        LunarEventInstance first = this.pastEvents.get(0);
        if (first.active(this.getCurrentDay())) {
            return this.lunarEventHolder(first.getLunarEventKey());
        }
        return defaultEvent;
    }

    public Holder<LunarEvent> getLunarEventForDay(long day) {
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            if (!lunarEventInstance.active(day)) continue;
            return this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
        }
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            if (!lunarEventInstance.active(day)) continue;
            return this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
        }
        return this.defaultLunarEvent();
    }

    public Component getForecastComponent() {
        MutableComponent textComponent = null;
        for (int i = Math.min(100, this.forecast.size() - 1); i >= 0; --i) {
            LunarEventInstance lunarEventInstance = this.forecast.get(i);
            Holder.Reference<LunarEvent> event = this.lunarEventHolder(lunarEventInstance.getLunarEventKey());
            CustomTranslationTextComponent name = ((LunarEvent)event.value()).getTextComponents().name();
            TextColor color = name.getStyle().getColor();
            if (textComponent == null) {
                textComponent = Component.translatable((String)name.getKey()).withStyle(Style.EMPTY.withColor(color));
            } else {
                textComponent.append((Component)Component.literal((String)", ").withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE))).append((Component)Component.translatable((String)name.getKey()).withStyle(Style.EMPTY.withColor(color)));
            }
            textComponent.append((Component)Component.translatable((String)"enhancedcelestials.lunarforecast.days_left", (Object[])new Object[]{lunarEventInstance.getDaysUntil(this.getCurrentDay())}).withStyle(Style.EMPTY.withColor(color)));
        }
        if (textComponent != null) {
            return Component.translatable((String)"enhancedcelestials.lunarforecast.header", (Object[])new Object[]{textComponent.append((Component)Component.literal((String)".").withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)))});
        }
        return Component.translatable((String)"enhancedcelestials.lunarforecast.empty", (Object[])new Object[]{textComponent}).withStyle(ChatFormatting.YELLOW);
    }

    private Holder.Reference<LunarEvent> defaultLunarEvent() {
        return this.lunarEventHolder(((LunarDimensionSettings)this.dimensionSettingsHolder.value()).defaultEvent());
    }

    private Holder.Reference<LunarEvent> lunarEventHolder(ResourceKey<LunarEvent> lunarEventKey) {
        return ((Registry)this.level.registryAccess().registry(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow()).getHolderOrThrow(lunarEventKey);
    }

    public Object2LongArrayMap<ResourceKey<LunarEvent>> eventsByDay() {
        Object2LongArrayMap eventByLastTime = new Object2LongArrayMap();
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            eventByLastTime.put(lunarEventInstance.getLunarEventKey(), lunarEventInstance.scheduledDay());
        }
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            eventByLastTime.put(lunarEventInstance.getLunarEventKey(), lunarEventInstance.scheduledDay());
        }
        return eventByLastTime;
    }

    public long lastScheduledEventDay() {
        long lastScheduledEventDay = -1L;
        for (LunarEventInstance lunarEventInstance : this.forecast) {
            lastScheduledEventDay = Math.max(lunarEventInstance.scheduledDay(), lastScheduledEventDay);
        }
        for (LunarEventInstance lunarEventInstance : this.pastEvents) {
            lastScheduledEventDay = Math.max(lunarEventInstance.scheduledDay(), lastScheduledEventDay);
        }
        return lastScheduledEventDay;
    }

    public long getCurrentDay() {
        return this.getDayFromDayTime(this.level.getDayTime());
    }

    public long getDayFromDayTime(long dayTime) {
        return dayTime / ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).dayLength();
    }

    public long getDayTimeFromDay(long day) {
        return day * ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).dayLength();
    }

    public float getBlend() {
        return this.blend;
    }

    private void createOrUpdateForecast(long lastCheckedDay) {
        long dayDifference;
        long yearLengthInDays = ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).yearLengthInDays();
        if (this.getCurrentDay() < lastCheckedDay - yearLengthInDays) {
            lastCheckedDay = this.getCurrentDay();
            this.setLastCheckedDay(lastCheckedDay);
        }
        if ((dayDifference = EnhancedCelestialsLunarForecastWorldData.clamp(lastCheckedDay - this.getCurrentDay(), 0L, yearLengthInDays)) < yearLengthInDays) {
            Object2LongArrayMap<ResourceKey<LunarEvent>> eventsByDay = this.eventsByDay();
            long lastScheduledEventDay = this.lastScheduledEventDay();
            long yearDayDifference = yearLengthInDays - dayDifference;
            int dayOffset = 0;
            while ((long)dayOffset <= yearDayDifference) {
                long day = this.getCurrentDay() + dayDifference + (long)dayOffset;
                long seed = day + ((ServerLevel)this.level).getSeed() + (long)this.level.dimension().hashCode();
                Random random = new Random(seed);
                ArrayList<Holder<LunarEvent>> scrambledLunarEvents = new ArrayList<Holder<LunarEvent>>(this.lunarEventSpawnRequirements.keySet());
                Collections.shuffle(scrambledLunarEvents, random);
                for (Holder holder : scrambledLunarEvents) {
                    boolean override;
                    LunarEvent.SpawnRequirements spawnRequirements = this.lunarEventSpawnRequirements.get(holder);
                    boolean pastMinNumberOfNightsBetweenThisTypeOfEvent = day - eventsByDay.getOrDefault(holder.unwrapKey().orElseThrow(), this.getCurrentDay()) > (long)spawnRequirements.minNumberOfNights();
                    boolean pastMinNumberOfNightsBetweenAllEvents = day - lastScheduledEventDay > ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).minDaysBetweenEvents();
                    boolean isValidMoonPhase = spawnRequirements.validMoonPhases().contains(this.level.dimensionType().moonPhase(this.getDayTimeFromDay(day)));
                    boolean chance = spawnRequirements.chance() >= random.nextDouble();
                    boolean checksPass = pastMinNumberOfNightsBetweenThisTypeOfEvent && pastMinNumberOfNightsBetweenAllEvents && isValidMoonPhase && chance;
                    boolean bl = override = !checksPass && lastScheduledEventDay != -1L && day - lastScheduledEventDay >= ((LunarDimensionSettings)this.dimensionSettingsHolder.value()).maxDaysBetweenEvents();
                    if (!checksPass && !override) continue;
                    lastScheduledEventDay = day;
                    LunarEventInstance newLunarEventInstance = new LunarEventInstance((ResourceKey<LunarEvent>)((ResourceKey)holder.unwrapKey().orElseThrow()), day);
                    eventsByDay.put(newLunarEventInstance.getLunarEventKey(), day);
                    this.forecast.add(newLunarEventInstance);
                }
                ++dayOffset;
            }
            this.setLastCheckedDay(this.getCurrentDay() + yearLengthInDays);
        }
    }

    public void setLastCheckedDay(long lastCheckedDay) {
        this.lastCheckedDay = lastCheckedDay;
        this.markChanged();
    }

    public void addEventToForecast(LunarEventInstance event) {
        this.forecast.add(event);
        this.markChanged();
    }

    public void addEventToForecast(int idx, LunarEventInstance event) {
        this.forecast.add(idx, event);
        this.markChanged();
    }

    public void removeEventInForecast(LunarEventInstance event) {
        this.forecast.remove(event);
        this.markChanged();
    }

    public void removeEventInForecast(int index) {
        this.forecast.remove(index);
        this.markChanged();
    }

    public void removeFromForecastIf(Predicate<LunarEventInstance> filter) {
        this.forecast.removeIf(lunarEventInstance -> {
            if (filter.test((LunarEventInstance)lunarEventInstance)) {
                this.markChanged();
                return true;
            }
            return false;
        });
    }

    public void removeFromPastEventsIf(Predicate<LunarEventInstance> filter) {
        this.pastEvents.removeIf(lunarEventInstance -> {
            if (filter.test((LunarEventInstance)lunarEventInstance)) {
                this.markChanged();
                return true;
            }
            return false;
        });
    }

    private void markChanged() {
        this.sync();
        this.markDirty();
    }

    public void sync() {
        if (!this.level.isClientSide) {
            this.shouldSync = true;
        }
    }

    private void checkServer() {
        if (this.level.isClientSide) {
            throw new IllegalStateException("MUST BE CALLED FROM SERVER SIDE ONLY!");
        }
    }

    public List<LunarEventInstance> getForecast() {
        return this.forecast;
    }

    public LunarDimensionSettings getDimensionSettings() {
        return (LunarDimensionSettings)this.dimensionSettingsHolder.value();
    }

    public Holder<LunarDimensionSettings> getDimensionSettingsHolder() {
        return this.dimensionSettingsHolder;
    }

    public static long clamp(long value, long min, long max) {
        return value < min ? min : Math.min(value, max);
    }

    @Nullable
    public static EnhancedCelestialsLunarForecastWorldData factory(TrackedDataKey<EnhancedCelestialsLunarForecastWorldData> key, Level level) {
        ResourceKey dimension = level.dimension();
        ResourceLocation location = dimension.location();
        Registry lunarDimensionSettingsRegistry = level.registryAccess().registryOrThrow(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY);
        Optional possibleLunarDimensionSettings = lunarDimensionSettingsRegistry.getHolder(ResourceKey.create(EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY, (ResourceLocation)location));
        if (possibleLunarDimensionSettings.isEmpty()) {
            return null;
        }
        Holder.Reference dimensionSettingsHolder = (Holder.Reference)possibleLunarDimensionSettings.orElseThrow();
        Registry lunarEvents = (Registry)level.registryAccess().registry(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
        Object2ObjectOpenHashMap<Holder<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements = EnhancedCelestialsLunarForecastWorldData.createLunarEventSpawnRequirements((ResourceKey<Level>)dimension, (Registry<LunarEventProbabilities>)level.registryAccess().registryOrThrow(EnhancedCelestialsRegistry.LUNAR_EVENT_PROBABILITIES_KEY), (Registry<LunarEvent>)lunarEvents, (Holder.Reference<LunarDimensionSettings>)dimensionSettingsHolder);
        return lunarEventSpawnRequirements.isEmpty() ? null : new EnhancedCelestialsLunarForecastWorldData(key, level, (Holder<LunarDimensionSettings>)dimensionSettingsHolder, (Map<Holder<LunarEvent>, LunarEvent.SpawnRequirements>)lunarEventSpawnRequirements);
    }

    private static Object2ObjectOpenHashMap<Holder<LunarEvent>, LunarEvent.SpawnRequirements> createLunarEventSpawnRequirements(ResourceKey<Level> dimension, Registry<LunarEventProbabilities> lunarEventProbabilitiesRegistry, Registry<LunarEvent> lunarEvents, Holder.Reference<LunarDimensionSettings> dimensionSettingsHolder) {
        Object2ObjectOpenHashMap lunarEventSpawnRequirements = new Object2ObjectOpenHashMap();
        for (Map.Entry resourceKeyLunarEventEntry : lunarEvents.entrySet()) {
            LunarEvent.SpawnRequirements spawnRequirements;
            Holder.Reference lunarEventHolder = lunarEvents.getHolderOrThrow((ResourceKey)resourceKeyLunarEventEntry.getKey());
            ResourceKey levelResourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceKey)dimensionSettingsHolder.unwrapKey().orElseThrow()).location());
            Map<ResourceKey<Level>, LunarEvent.SpawnRequirements> eventChancesByDimension = ((LunarEvent)lunarEventHolder.value()).getEventChancesByDimension();
            if (!eventChancesByDimension.containsKey(levelResourceKey) || !((spawnRequirements = eventChancesByDimension.get(levelResourceKey)).chance() > 0.0) || spawnRequirements.validMoonPhases().isEmpty() || spawnRequirements.minNumberOfNights() < 0) continue;
            lunarEventSpawnRequirements.put((Object)lunarEventHolder, (Object)spawnRequirements);
        }
        EnhancedCelestialsLunarForecastWorldData.insertOverrides(lunarEventProbabilitiesRegistry, dimension, (Object2ObjectOpenHashMap<Holder<LunarEvent>, LunarEvent.SpawnRequirements>)lunarEventSpawnRequirements, lunarEvents);
        return lunarEventSpawnRequirements;
    }

    private static void insertOverrides(Registry<LunarEventProbabilities> lunarEventProbabilitiesRegistry, ResourceKey<Level> dimension, Object2ObjectOpenHashMap<Holder<LunarEvent>, LunarEvent.SpawnRequirements> lunarEventSpawnRequirements, Registry<LunarEvent> lunarEvents) {
        Object2ObjectRBTreeMap loggerData = new Object2ObjectRBTreeMap(Comparator.comparing(ResourceKey::location));
        lunarEventProbabilitiesRegistry.entrySet().stream().sorted(Comparator.comparingInt(value -> ((LunarEventProbabilities)value.getValue()).priority())).forEachOrdered(lunarEventProbabilitiesEntry -> {
            ResourceKey lunarEventProbabilitiesKey = (ResourceKey)lunarEventProbabilitiesEntry.getKey();
            LunarEventProbabilities lunarEventProbabilitiesEntryValue = (LunarEventProbabilities)lunarEventProbabilitiesEntry.getValue();
            Map<ResourceKey<LunarEvent>, Map<ResourceKey<Level>, LunarEvent.SpawnRequirements>> lunarEventProbabilitiesByDimension = lunarEventProbabilitiesEntryValue.probabilitiesByEvent();
            lunarEventProbabilitiesByDimension.forEach((lunarEventResourceKey, value) -> {
                LunarEvent.SpawnRequirements spawnRequirementsOverride = (LunarEvent.SpawnRequirements)value.get(dimension);
                if (spawnRequirementsOverride != null) {
                    if (!loggerData.containsKey(lunarEventResourceKey)) {
                        String s = "set";
                        if (lunarEventSpawnRequirements.containsKey((Object)lunarEvents.getHolderOrThrow(lunarEventResourceKey))) {
                            s = "replaced";
                        }
                        loggerData.put(lunarEventResourceKey, (Object)new StringBuilder("[%s]: Lunar Event probability for \"%s\" was %s by highest priority lunar event probability \"%s\" with priority %d.".formatted(dimension.location().toString(), lunarEventResourceKey.location().toString(), s, lunarEventProbabilitiesKey.location().toString(), lunarEventProbabilitiesEntryValue.priority())));
                        lunarEventSpawnRequirements.put((Object)lunarEvents.getHolderOrThrow(lunarEventResourceKey), (Object)spawnRequirementsOverride);
                    } else {
                        StringBuilder builder = (StringBuilder)loggerData.get(lunarEventResourceKey);
                        if (!builder.toString().contains("Ignored")) {
                            builder.append(" | Ignored the following lunar event probabilities to due having a lower priority: ");
                        }
                        if (builder.toString().contains("[Probability")) {
                            builder.append(", ");
                        }
                        builder.append("[Probability=%s,Priority%d]".formatted(lunarEventProbabilitiesKey.location().toString(), lunarEventProbabilitiesEntryValue.priority()));
                    }
                }
            });
        });
        loggerData.values().forEach(stringBuilder -> EnhancedCelestials.LOGGER.info(stringBuilder.toString()));
    }
}

