/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.entity;

import dev.corgitaco.enhancedcelestials.core.ECBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public final class SpaceMossBugEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> COVERED_IN_SPORES = SynchedEntityData.defineId(SpaceMossBugEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> SPORE_DELAY = SynchedEntityData.defineId(SpaceMossBugEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public SpaceMossBugEntity(EntityType<? extends PathfinderMob> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COVERED_IN_SPORES, (Object)false);
        builder.define(SPORE_DELAY, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag $$0) {
        super.readAdditionalSaveData($$0);
        this.setCoveredInSpores($$0.getBoolean("CoveredInSpores"));
        this.setSporeDelay($$0.getByte("SporeDelay"));
    }

    public void addAdditionalSaveData(CompoundTag $$0) {
        super.addAdditionalSaveData($$0);
        $$0.putBoolean("CoveredInSpores", this.isCoveredInSpores());
        $$0.putByte("SporeDelay", this.getSporeDelay());
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            byte sporeDelay;
            if (this.tickCount % 20 == 0 && (sporeDelay = this.getSporeDelay()) > 0) {
                this.setSporeDelay((byte)(sporeDelay - 1));
            }
            if (this.isCoveredInSpores() && this.random.nextInt(96) == 0) {
                BlockState blockState = (this.random.nextBoolean() ? ECBlocks.SPACE_MOSS_CARPET : ECBlocks.SPACE_MOSS_GRASS).get().defaultBlockState();
                BlockPos blockPos = this.blockPosition();
                if (this.level().isEmptyBlock(blockPos) && blockState.canSurvive((LevelReader)this.level(), blockPos) && this.level().setBlock(blockPos, blockState, 2)) {
                    this.setCoveredInSpores(false);
                    this.setSporeDelay((byte)-2);
                }
            }
        }
        if (this.level().isClientSide && this.isCoveredInSpores()) {
            for (int i = 0; i < 5; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FALLING_NECTAR, this.getX() + Mth.nextDouble((RandomSource)this.random, (double)-0.4, (double)0.4), this.getY() + Mth.nextDouble((RandomSource)this.random, (double)-0.4, (double)0.4), this.getZ() + Mth.nextDouble((RandomSource)this.random, (double)-0.4, (double)0.4), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isCoveredInSpores() {
        return (Boolean)this.entityData.get(COVERED_IN_SPORES);
    }

    public byte getSporeDelay() {
        return (Byte)this.entityData.get(SPORE_DELAY);
    }

    public void setCoveredInSpores(boolean b) {
        this.entityData.set(COVERED_IN_SPORES, (Object)b);
    }

    public void setSporeDelay(byte b) {
        this.entityData.set(SPORE_DELAY, (Object)b);
    }
}

