/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.infinitystorage.block.entity.handlers;

import com.benbenlaw.infinitystorage.item.InfinityDrive;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class InfinityDriveItemHandler
extends ItemStackHandler {
    private final InfinityDrive drive;

    public InfinityDriveItemHandler(InfinityDrive drive) {
        super(1);
        this.drive = drive;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (this.drive.getContent().isItem()) {
            ItemStack copy = this.drive.getContent().getInfinityStack().copy();
            copy.setCount(Integer.MAX_VALUE);
            return copy;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.drive.getContent().isItem()) {
            return new ItemStack((ItemLike)this.drive.getContent().getInfinityStack().getItem(), amount);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.drive.getContent().isItem() && stack.is(this.drive.getContent().getInfinityStack().getItem())) {
            return ItemStack.EMPTY;
        }
        return stack;
    }
}

