/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.worldgen;

import com.benbenlaw.colors.worldgen.ColorsPlacedFeatures;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ColorsBiomeModifiers {
    public static final Map<String, ResourceKey<BiomeModifier>> ADD_TREES = new HashMap<String, ResourceKey<BiomeModifier>>();
    public static final Map<String, ResourceKey<BiomeModifier>> ADD_STONES = new HashMap<String, ResourceKey<BiomeModifier>>();

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(ADD_TREES.get("black"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.DARK_FOREST)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("black"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("red"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_JUNGLE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("red"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("green"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_JUNGLE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("green"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("brown"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_SWAMP), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("brown"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("blue"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_SNOWY), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("blue"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("purple"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("purple"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("cyan"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_SNOWY), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("cyan"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("light_gray"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_MOUNTAIN), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("light_gray"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("gray"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_MOUNTAIN), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("gray"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("pink"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("pink"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("lime"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_JUNGLE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("lime"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("yellow"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_DESERT), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("yellow"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("light_blue"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_SNOWY), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("light_blue"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("magenta"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_FOREST), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("magenta"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("orange"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_BADLANDS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("orange"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_TREES.get("white"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_SNOWY), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.TREE_PLACED.get("white"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        for (String color : ColorList.COLORS) {
            context.register(ADD_STONES.get(color), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ColorsPlacedFeatures.STONE_PLACED.get(color))}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"colors", (String)name));
    }

    static {
        for (String color : ColorList.COLORS) {
            ADD_TREES.put(color, ColorsBiomeModifiers.registerKey(color + "_tree"));
            ADD_STONES.put(color, ColorsBiomeModifiers.registerKey(color + "_stone"));
        }
    }
}

