/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.core.block.colored.util.ColorMap;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.StringRepresentable;

public class ColorsTextureProvider
implements DataProvider {
    private final PackOutput packOutput;

    public ColorsTextureProvider(PackOutput output) {
        this.packOutput = output;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return CompletableFuture.runAsync(() -> {
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "apple", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "sapling", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_door", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_door", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_sign", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_hanging_sign", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_sign", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_hanging_sign", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_sign", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_hanging_sign", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "asteroid", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "asteroid_bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "asteroid_tiles", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_door_bottom", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_door_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_trapdoor", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_planks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_door_bottom", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_door_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_trapdoor", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "braid", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "chaotic", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "cobblestone", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "cobblestone_bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "cracked_stone_bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "crafting_table", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "crafting_table_side", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "crafting_table_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "dandelion", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "dark_prismarine", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "dirt", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "encased", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "encased_connected", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "grass_block_side", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "grass_block_side_snow", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "grass_block_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "grass_block_top_snow", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "leaves", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "log", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "log_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "marble", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "marble_bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "mosaic", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "planks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_door_bottom", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_door_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_door", "item");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_trapdoor", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "polished", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "poppy", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "prismarine", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "prismarine_bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "road", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "sapling", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "short_grass", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "stone", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "stone_bricks", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "stripped_bamboo", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "stripped_bamboo_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "stripped_log", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "stripped_log_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "tall_grass_bottom", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "tall_grass_top", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "tiles", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "triple", "block");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_sign", "entity/signs/hanging");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_sign", "entity/signs/hanging");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_sign", "entity/signs/hanging");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_sign", "entity/signs");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_sign", "entity/signs");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_sign", "entity/signs");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "plank_sign", "gui/hanging_signs");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_plank_sign", "gui/hanging_signs");
            this.generateTintedTextures(cache, ColorMap.COLOR_MAP, "bamboo_mosaic_sign", "gui/hanging_signs");
        });
    }

    private void generateTintedTextures(CachedOutput cache, Map<? extends StringRepresentable, Integer> values, String baseTexture, String type) {
        BufferedImage baseImage;
        try (InputStream is = ColorsTextureProvider.class.getClassLoader().getResourceAsStream("assets/colors/textures/" + type + "/" + baseTexture + ".png");){
            if (is == null) {
                throw new RuntimeException("Base texture not found at assets/colors/textures/" + type + "/" + baseTexture + ".png");
            }
            baseImage = ImageIO.read(is);
            if (baseImage == null) {
                throw new RuntimeException("Failed to read base texture as an image.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading base texture", e);
        }
        for (Map.Entry<? extends StringRepresentable, Integer> entry : values.entrySet()) {
            StringRepresentable dyeColor = entry.getKey();
            int tint = entry.getValue();
            BufferedImage tintedImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
            for (int x = 0; x < baseImage.getWidth(); ++x) {
                for (int y = 0; y < baseImage.getHeight(); ++y) {
                    int pixel = baseImage.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    int tintRed = tint >> 16 & 0xFF;
                    int tintGreen = tint >> 8 & 0xFF;
                    int tintBlue = tint & 0xFF;
                    int newRed = red * tintRed / 255;
                    int newGreen = green * tintGreen / 255;
                    int newBlue = blue * tintBlue / 255;
                    tintedImage.setRGB(x, y, alpha << 24 | newRed << 16 | newGreen << 8 | newBlue);
                }
            }
            Path outputPath = this.packOutput.getOutputFolder().resolve("assets\\colors\\textures\\" + type + "\\" + dyeColor.getSerializedName() + "_" + baseTexture + ".png");
            Path parent = outputPath.getParent();
            if (!parent.toFile().exists() && !parent.toFile().mkdirs()) {
                throw new RuntimeException("Failed to create output folder: " + String.valueOf(parent));
            }
            try {
                HashingOutputStream hashingoutputstream;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                try (HashingOutputStream stream = hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);){
                    ImageIO.write((RenderedImage)tintedImage, "png", (OutputStream)stream);
                }
                cache.writeIfNeeded(outputPath, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getName() {
        return "Colors Texture Provider";
    }
}

