/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.modify;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalcustomization.MysticalCustomization;
import com.blakebr0.mysticalcustomization.loader.MobSoulTypeLoader;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public final class MobSoulTypeModifier {
    public static void modify(MobSoulType type, JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        if (json.has("souls")) {
            float souls = GsonHelper.getAsFloat((JsonObject)json, (String)"souls");
            type.setSoulRequirement((double)souls);
        }
        if (json.has("entities")) {
            JsonObject entities = GsonHelper.getAsJsonObject((JsonObject)json, (String)"entities");
            if (entities.has("remove")) {
                JsonArray remove = GsonHelper.getAsJsonArray((JsonObject)entities, (String)"remove");
                remove.forEach(entity -> {
                    boolean success = MysticalAgricultureAPI.getMobSoulTypeRegistry().removeEntityFrom(type, ResourceLocation.parse((String)entity.getAsString()));
                    if (!success) {
                        MysticalCustomization.LOGGER.error("Could not remove entity {} from mob soul type {}, maybe it wasn't added?", (Object)entity.getAsString(), (Object)type.getId());
                    }
                });
            }
            if (entities.has("add")) {
                JsonArray add = GsonHelper.getAsJsonArray((JsonObject)entities, (String)"add");
                add.forEach(entity -> MobSoulTypeLoader.ENTITY_ADDITIONS_MAP.computeIfAbsent(type, t -> new ArrayList()).add(ResourceLocation.parse((String)entity.getAsString())));
            }
        }
        if (json.has("color")) {
            String color = GsonHelper.getAsString((JsonObject)json, (String)"color");
            int i = ParsingHelper.parseHex((String)color, (String)"color");
            type.setColor(i);
        }
        if (json.has("name")) {
            String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
            type.setEntityDisplayName((Component)Component.literal((String)name));
        }
        if (json.has("enabled")) {
            boolean enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled");
            type.setEnabled(enabled);
        }
    }
}

