/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.widgets;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class ClickableText {
    private final String text;
    private final int x;
    private final int y;
    private final Consumer<ClickableText> onClick;

    public ClickableText(String text, int x, int y, Consumer<ClickableText> onClick) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.onClick = onClick;
    }

    public void render(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
        boolean isHovered = this.isMouseOver(font, mouseX, mouseY);
        int color = isHovered ? 0xFF0000 : 255;
        guiGraphics.drawString(font, this.text, this.x - font.width(this.text) / 2, this.y, color, false);
    }

    public boolean isMouseOver(Font font, int mouseX, int mouseY) {
        int textWidth = font.width(this.text);
        int xStart = this.x - textWidth / 2;
        int xEnd = this.x + textWidth / 2;
        int yStart = this.y;
        Objects.requireNonNull(font);
        int yEnd = this.y + 9;
        return mouseX >= xStart && mouseX <= xEnd && mouseY >= yStart && mouseY <= yEnd;
    }

    public void mouseClicked(Font font, int mouseX, int mouseY, int button) {
        if (this.isMouseOver(font, mouseX, mouseY) && button == 0 && this.onClick != null) {
            this.onClick.accept(this);
        }
    }

    public String getText() {
        return this.text;
    }
}

