/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.util.entitiy;

import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class PSideConfigHelper {
    private final EnumMap<Direction, SlotType> sideSlotMap = new EnumMap(Direction.class);

    public PSideConfigHelper() {
        this.initDefault();
    }

    private void initDefault() {
        this.sideSlotMap.put(Direction.UP, SlotType.INPUT);
        this.sideSlotMap.put(Direction.DOWN, SlotType.OUTPUT);
    }

    private void initDefaultAfterReset() {
        this.sideSlotMap.put(Direction.UP, SlotType.NONE);
        this.sideSlotMap.put(Direction.DOWN, SlotType.NONE);
        this.sideSlotMap.put(Direction.NORTH, SlotType.NONE);
        this.sideSlotMap.put(Direction.SOUTH, SlotType.NONE);
        this.sideSlotMap.put(Direction.EAST, SlotType.NONE);
        this.sideSlotMap.put(Direction.WEST, SlotType.NONE);
    }

    public void setSlotType(Direction facing, SlotType type) {
        this.sideSlotMap.put(facing, type);
    }

    public SlotType getSlotType(Direction facing) {
        return this.sideSlotMap.getOrDefault(facing, SlotType.NONE);
    }

    public void resetToDefault() {
        this.sideSlotMap.clear();
        this.initDefaultAfterReset();
    }

    public void saveToNBT(CompoundTag tag) {
        for (Direction side : this.sideSlotMap.keySet()) {
            tag.putString("Slot_" + side.getName(), this.sideSlotMap.get(side).name());
        }
    }

    public void loadFromNBT(CompoundTag tag) {
        for (Direction side : Direction.values()) {
            if (!tag.contains("Slot_" + side.getName())) continue;
            SlotType type = SlotType.valueOf(tag.getString("Slot_" + side.getName()));
            this.sideSlotMap.put(side, type);
        }
    }

    public int sideTypeToIndex(Direction direction) {
        return this.getSlotType(direction).ordinal();
    }

    public void setSlotType(Direction facing, int value) {
        SlotType type = SlotType.values()[value];
        this.sideSlotMap.put(facing, type);
    }

    public void cycleSlotType(Direction facing) {
        SlotType type = this.getSlotType(facing);
        int nextOrdinal = (type.ordinal() + 1) % SlotType.values().length;
        this.sideSlotMap.put(facing, SlotType.values()[nextOrdinal]);
    }

    public void cycleReversSlotType(Direction facing) {
        SlotType type = this.getSlotType(facing);
        int nextOrdinal = (type.ordinal() - 1 + SlotType.values().length) % SlotType.values().length;
        this.sideSlotMap.put(facing, SlotType.values()[nextOrdinal]);
    }

    public static enum SlotType {
        NONE,
        INPUT,
        OUTPUT,
        IO;

    }
}

