/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen.powered;

import net.biorfn.compressedfurnace.menu.powered.AbstractCompressedPoweredMenu;
import net.biorfn.compressedfurnace.network.AutoSplitToggleButton;
import net.biorfn.compressedfurnace.network.Messages;
import net.biorfn.compressedfurnace.screen.AbstractCompressedScreen;
import net.biorfn.compressedfurnace.util.GuiEnergy;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractCompressedPoweredScreen<T extends AbstractCompressedPoweredMenu>
extends AbstractCompressedScreen<T> {
    private GuiEnergy energyBar;

    public AbstractCompressedPoweredScreen(T menu, Inventory playerInventory, Component title, String teirId, String type) {
        super(menu, playerInventory, title, teirId, "powered_" + type);
    }

    @Override
    protected void init() {
        super.init();
        this.renderAutoSplitButton();
        this.energyBar = new GuiEnergy(this.leftPos, this.topPos, 22, 17, 14, 42);
        this.renderXPButton();
    }

    @Override
    protected void renderAutoSplitButton() {
        int buttonX = this.leftPos + 7;
        int buttonY = this.topPos + 5;
        this.toggleAutoSplit = this.createButton("S", buttonX, buttonY, 14, 14, button -> Messages.sendToServer(AutoSplitToggleButton.create()));
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        this.renderBG(guiGraphics);
        this.renderHasXP(guiGraphics);
        this.renderEnergyBar(guiGraphics);
        this.renderProgressBars(guiGraphics);
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics) {
        int energyHeight = this.getScaledEnergyHeight();
        if (energyHeight > 0) {
            guiGraphics.blit(this.getTierGUITexture(), this.leftPos + 22, this.topPos + 17 + (42 - energyHeight), 176, this.type.equals("powered_crusher") ? 16 : 22, 14, energyHeight);
        }
    }

    @Override
    protected void renderHasXP(GuiGraphics guiGraphics) {
        int sButtonX = this.leftPos + 22;
        int sButtonY = this.topPos + 62;
        if (((AbstractCompressedPoweredMenu)this.menu).hasXPWaiting()) {
            guiGraphics.blit(this.getTierGUITexture(), sButtonX, sButtonY, 176, this.type.equals("powered_crusher") ? 59 : 65, 11, 15);
        }
    }

    protected int getScaledEnergyHeight() {
        int maxEnergy = ((AbstractCompressedPoweredMenu)this.menu).getMaxEnergy();
        int currentEnergy = ((AbstractCompressedPoweredMenu)this.menu).getEnergy();
        if (maxEnergy == 0) {
            return 0;
        }
        return currentEnergy * 42 / maxEnergy;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.energyBar.renderTooltip(this.font, guiGraphics, mouseX, mouseY, ((AbstractCompressedPoweredMenu)this.menu).getEnergy(), ((AbstractCompressedPoweredMenu)this.menu).getMaxEnergy(), true, true);
    }
}

