/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen.generator;

import net.biorfn.compressedfurnace.menu.generator.GeneratorMenu;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.biorfn.compressedfurnace.util.GuiEnergy;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public abstract class GeneratorScreen<T extends GeneratorMenu>
extends AbstractContainerScreen<T> {
    public ResourceLocation GUI = CallConstants.getLocation("textures/gui/generator.png");
    private static final ResourceLocation BURN_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/furnace/burn_progress");
    Inventory playerInv;
    Component name;
    String teirId;
    private GuiEnergy energyBar;
    private GuiEnergy lavaTank;

    public GeneratorScreen(T menu, Inventory playerInventory, Component title, String teirId) {
        super(menu, playerInventory, title);
        this.name = title;
        this.playerInv = playerInventory;
        this.teirId = teirId;
    }

    protected void init() {
        super.init();
        this.energyBar = new GuiEnergy(this.leftPos, this.topPos, 117, 22, 14, 42);
        this.lavaTank = new GuiEnergy(this.leftPos, this.topPos, 20, 14, 18, 62);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.imageHeight - this.imageHeight - 10, 0x404040);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName(), this.titleLabelX, -2000, 0x404040);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        this.energyBar.renderTooltip(this.font, guiGraphics, mouseX, mouseY, ((GeneratorMenu)this.menu).getEnergy(), ((GeneratorMenu)this.menu).getMaxEnergy(), true, true);
        this.lavaTank.renderTooltip(this.font, guiGraphics, mouseX, mouseY, ((GeneratorMenu)this.menu).getLava(), ((GeneratorMenu)this.menu).getMaxLava(), true, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        int lavaHeight;
        guiGraphics.blit(this.GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int energyHeight = this.getScaledEnergyHeight();
        if (energyHeight > 0) {
            guiGraphics.blit(this.GUI, this.leftPos + 117, this.topPos + 22 + (42 - energyHeight), 176, 1, 14, energyHeight);
        }
        if (((GeneratorMenu)this.menu).isLit()) {
            int maxLitHeight = 13;
            int litHeight = (int)(((GeneratorMenu)this.menu).getBurnProgress() * (float)maxLitHeight);
            int litYOffset = maxLitHeight - litHeight;
            guiGraphics.blit(this.GUI, this.leftPos + 57, this.topPos + 24 + litYOffset, 176, 42 + litYOffset, 14, litHeight);
        }
        if ((lavaHeight = this.getScaledLavaHeight()) > 0) {
            guiGraphics.blit(this.GUI, this.leftPos + 20, this.topPos + 14 + (62 - lavaHeight), 176, 57, 18, lavaHeight);
        }
        this.renderProgressBar(guiGraphics);
    }

    private void renderProgressBar(GuiGraphics guiGraphics) {
        int progressWidth = Mth.ceil((float)(((GeneratorMenu)this.menu).getBurnProgress() * 24.0f));
        if (progressWidth > 0) {
            guiGraphics.blit(this.GUI, this.leftPos + 87, this.topPos + 35, 176, 118, 24 - progressWidth, 16);
        }
    }

    private int getScaledEnergyHeight() {
        int maxEnergy = ((GeneratorMenu)this.menu).getMaxEnergy();
        int currentEnergy = ((GeneratorMenu)this.menu).getEnergy();
        if (maxEnergy == 0) {
            return 0;
        }
        return currentEnergy * 42 / maxEnergy;
    }

    private int getScaledLavaHeight() {
        int maxLava = ((GeneratorMenu)this.menu).getMaxLava();
        int currentLava = ((GeneratorMenu)this.menu).getLava();
        if (maxLava == 0) {
            return 0;
        }
        return currentLava * 62 / maxLava;
    }
}

