/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.biorfn.compressedfurnace.CompressedFurnace;
import net.biorfn.compressedfurnace.menu.AbstractCompressedMenu;
import net.biorfn.compressedfurnace.network.AutoExport;
import net.biorfn.compressedfurnace.network.AutoSplitToggleButton;
import net.biorfn.compressedfurnace.network.Messages;
import net.biorfn.compressedfurnace.network.SetSideIO;
import net.biorfn.compressedfurnace.network.SetSideIOReverse;
import net.biorfn.compressedfurnace.network.XPButton;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.biorfn.compressedfurnace.util.entitiy.SideConfigHelper;
import net.biorfn.compressedfurnace.util.widgets.ClickableArea;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractCompressedScreen<T extends AbstractCompressedMenu>
extends AbstractContainerScreen<T> {
    public final ResourceLocation GUI;
    public final ResourceLocation DOUBLE_GUI;
    public final ResourceLocation TRIPLE_GUI;
    protected Button toggleAutoSplit;
    protected Button toggleUpSide;
    protected Button toggleDownSide;
    protected Button toggleRightSide;
    protected Button toggleLeftSide;
    protected Button toggleCenterSide;
    protected Button toggleBackSide;
    protected Button toggleReset;
    protected Button toggleSideConfig;
    protected Button toggleAutoExport;
    public ClickableArea XP_BOTTLE;
    protected final int sButtonWidth = 11;
    protected final int sButtonHeight = 15;
    Inventory playerInv;
    Component name;
    protected String teirId;
    protected String type;
    boolean sideActive = false;

    public AbstractCompressedScreen(T menu, Inventory playerInventory, Component title, String teirId, String type) {
        super(menu, playerInventory, title);
        this.GUI = CallConstants.getLocation("textures/gui/" + this.blockName(type) + "_factory.png");
        this.DOUBLE_GUI = CallConstants.getLocation("textures/gui/" + this.blockName(type) + "_double_factory.png");
        this.TRIPLE_GUI = CallConstants.getLocation("textures/gui/" + this.blockName(type) + "_triple_factory.png");
        this.playerInv = playerInventory;
        this.name = title;
        this.teirId = teirId;
        this.type = type;
    }

    protected void init() {
        super.init();
        this.renderButtons();
        this.setSideButtonsVisibility(false);
    }

    private void renderButtons() {
        this.renderAutoSplitButton();
        if (CompressedFurnace.AUTO_EXPORT) {
            this.renderAutoExportButton();
        }
        this.renderSideButtonsIO();
        this.renderXPButton();
        this.renderSideConfigButton();
    }

    protected void renderAutoSplitButton() {
        int buttonX = this.leftPos + 9;
        int buttonY = this.topPos + 5;
        this.toggleAutoSplit = this.createButton("S", buttonX, buttonY, 14, 14, button -> Messages.sendToServer(AutoSplitToggleButton.create()));
    }

    protected void renderSideConfigButton() {
        this.toggleSideConfig = this.createButton("<", this.leftPos + 2, this.topPos + 55, 9, 9, button -> {
            this.sideActive = !this.sideActive;
        });
    }

    protected void renderAutoExportButton() {
        int buttonX = this.leftPos - 18;
        int buttonY = this.topPos + 5;
        this.toggleAutoExport = this.createButton("E", buttonX, buttonY, 14, 14, button -> Messages.sendToServer(AutoExport.create()));
    }

    protected void renderSideButtonsIO() {
        int buttonX = this.leftPos - 18;
        int buttonY = this.topPos + 35;
        int buttonSize = 9;
        int gap = 5;
        this.toggleUpSide = this.createButton("U", buttonX, buttonY - 10, 9, 9, button -> {});
        this.toggleLeftSide = this.createButton("L", buttonX - 10, buttonY, 9, 9, button -> {});
        this.toggleCenterSide = this.createButton("C", buttonX, buttonY, 9, 9, button -> {});
        this.toggleRightSide = this.createButton("R", buttonX + 10, buttonY, 9, 9, button -> {});
        this.toggleBackSide = this.createButton("B", buttonX + 10, buttonY + 10, 9, 9, button -> {});
        this.toggleDownSide = this.createButton("D", buttonX, buttonY + 10, 9, 9, button -> {});
        this.toggleReset = this.createButton("Reset", buttonX - 10 - 5, buttonY + 10 + 10, 32, 9, button -> Messages.sendToServer(new SetSideIO(null, true)));
    }

    protected void renderSideColorsIO() {
        Direction side = ((AbstractCompressedMenu)this.menu).getFacing();
        this.updateButtonStyle(this.toggleUpSide, "U", ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(Direction.UP));
        this.updateButtonStyle(this.toggleLeftSide, "L", ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(side.getClockWise()));
        this.updateButtonStyle(this.toggleCenterSide, "C", ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(side));
        this.updateButtonStyle(this.toggleRightSide, "R", ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(side.getCounterClockWise()));
        this.updateButtonStyle(this.toggleDownSide, "D", ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(Direction.DOWN));
        this.updateButtonStyle(this.toggleBackSide, "B", ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(side.getOpposite()));
    }

    protected void renderXPButton() {
        int XP_Button_X = this.leftPos + 22;
        int XP_Button_Y = this.topPos + 62;
        this.XP_BOTTLE = new ClickableArea(XP_Button_X, XP_Button_Y, 11, 15, button -> Messages.sendToServer(XPButton.create()));
        this.XP_BOTTLE.active = ((AbstractCompressedMenu)this.menu).hasXPWaiting();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.updateAutoSplitButtonStyle();
        if (CompressedFurnace.AUTO_EXPORT) {
            this.updateAutoExportButtonStyle();
        }
        this.setSideButtonsVisibility(this.sideActive);
        this.renderSideColorsIO();
        this.renderButtonTooltips(guiGraphics, mouseX, mouseY);
        this.renderXPTooltip(guiGraphics, mouseX, mouseY);
        this.renderLockedInput(guiGraphics);
    }

    protected void renderButtonTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderButtonTooltip(guiGraphics, this.toggleAutoSplit, mouseX, mouseY, "Split Inputs", "Current State: " + (((AbstractCompressedMenu)this.menu).autoSplitEnabled() ? "ON" : "OFF"), false);
        if (CompressedFurnace.AUTO_EXPORT) {
            this.renderButtonTooltip(guiGraphics, this.toggleAutoExport, mouseX, mouseY, "Auto Export", "Current State: " + (((AbstractCompressedMenu)this.menu).exportEnabled() ? "ON" : "OFF"), false);
        }
        this.renderButtonTooltip(guiGraphics, this.toggleUpSide, mouseX, mouseY, "Side: " + Direction.UP.getName(), "Current State: " + ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(Direction.UP).name(), this.getSideActive(((AbstractCompressedMenu)this.menu).getSlotTypeForSide(Direction.UP)));
        this.renderButtonTooltip(guiGraphics, this.toggleDownSide, mouseX, mouseY, "Side: " + Direction.DOWN.getName(), "Current State: " + ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(Direction.DOWN).name(), this.getSideActive(((AbstractCompressedMenu)this.menu).getSlotTypeForSide(Direction.DOWN)));
        this.renderButtonTooltip(guiGraphics, this.toggleLeftSide, mouseX, mouseY, "Side: " + ((AbstractCompressedMenu)this.menu).getFacing().getClockWise().getName() + "/LEFT", "Current State: " + ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing().getClockWise()).name(), this.getSideActive(((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing().getClockWise())));
        this.renderButtonTooltip(guiGraphics, this.toggleCenterSide, mouseX, mouseY, "Side: " + ((AbstractCompressedMenu)this.menu).getFacing().getName() + "/Face", "Current State: " + ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing()).name(), this.getSideActive(((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing())));
        this.renderButtonTooltip(guiGraphics, this.toggleRightSide, mouseX, mouseY, "Side: " + ((AbstractCompressedMenu)this.menu).getFacing().getCounterClockWise().getName() + "/RIGHT", "Current State: " + ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing().getCounterClockWise()).name(), this.getSideActive(((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing().getCounterClockWise())));
        this.renderButtonTooltip(guiGraphics, this.toggleBackSide, mouseX, mouseY, "Side: " + ((AbstractCompressedMenu)this.menu).getFacing().getOpposite().getName() + "/BACK", "Current State: " + ((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing().getOpposite()).name(), this.getSideActive(((AbstractCompressedMenu)this.menu).getSlotTypeForSide(((AbstractCompressedMenu)this.menu).getFacing().getOpposite())));
        this.renderButtonTooltip(guiGraphics, this.toggleReset, mouseX, mouseY, "Reset", "Click to reset the sides.", false);
    }

    private void renderButtonTooltip(GuiGraphics guiGraphics, Button button, int mouseX, int mouseY, String message1, String message2, boolean sideActive) {
        if (!this.isMouseOverButton(button, mouseX, mouseY)) {
            return;
        }
        List<FormattedCharSequence> toolpLines = List.of(Component.literal((String)message1).getVisualOrderText(), Component.literal((String)message2).getVisualOrderText());
        if (sideActive) {
            toolpLines = List.of(Component.literal((String)message1).getVisualOrderText(), Component.literal((String)message2).getVisualOrderText(), Component.literal((String)"Hold Shift to Clear this Side!").getVisualOrderText());
        }
        guiGraphics.renderTooltip(this.font, toolpLines, DefaultTooltipPositioner.INSTANCE, mouseX, mouseY);
    }

    private boolean isMouseOverButton(Button button, int mouseX, int mouseY) {
        return mouseX >= button.getX() && mouseX <= button.getX() + button.getWidth() && mouseY >= button.getY() && mouseY <= button.getY() + button.getHeight();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, -10, 0x404040);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName(), this.titleLabelX, -2000, 0x404040);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        this.renderBG(guiGraphics);
        this.renderHasXP(guiGraphics);
        this.renderLitIndicator(guiGraphics);
        this.renderProgressBars(guiGraphics);
    }

    protected void renderBG(GuiGraphics guiGraphics) {
        guiGraphics.blit(this.getTierGUITexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderHasXP(GuiGraphics guiGraphics) {
        if (((AbstractCompressedMenu)this.menu).hasXPWaiting()) {
            guiGraphics.blit(this.getTierGUITexture(), this.leftPos + 22, this.topPos + 62, 176, 38, 11, 15);
        }
    }

    protected void renderLitIndicator(GuiGraphics guiGraphics) {
        if (!((AbstractCompressedMenu)this.menu).isLit()) {
            return;
        }
        int litHeight = (int)(((AbstractCompressedMenu)this.menu).getLitProgress() * 13.0f);
        int litYOffset = 13 - litHeight;
        guiGraphics.blit(this.getTierGUITexture(), this.leftPos + 10, this.topPos + 20 + litYOffset, 176, 23 + litYOffset, 14, litHeight);
    }

    protected void renderProgressBars(GuiGraphics guiGraphics) {
        int baseX = this.getXStart(this.teirId);
        int baseY = this.getBaseY(this.type);
        int slotOffsetX = 21;
        int[] slotIndices = ((AbstractCompressedMenu)this.menu).SlotForInput(this.teirId);
        for (int i = 0; i < slotIndices.length; ++i) {
            int xPosition = this.leftPos + baseX + i * 21;
            int yPosition = this.topPos + baseY;
            int progress = ((AbstractCompressedMenu)this.menu).getProgressForSlot(2 + i * 2);
            int maxProgress = ((AbstractCompressedMenu)this.menu).getMaxProgressForSlot(3 + i * 2);
            float progressRatio = maxProgress == 0 ? 0.0f : (float)progress / (float)maxProgress;
            int maxHeight = this.type.contains("crusher") ? 16 : 24;
            int baseWidth = this.type.contains("crusher") ? 18 : 16;
            int scaledHeight = (int)(progressRatio * (float)maxHeight);
            guiGraphics.blit(this.getTierGUITexture(), xPosition, yPosition, 176, 0, baseWidth, scaledHeight);
        }
    }

    protected void renderLockedInput(GuiGraphics guiGraphics) {
        Map<Integer, List<ItemStack>> slotSuggestions = ((AbstractCompressedMenu)this.menu).getSlotInputSuggestions();
        for (Map.Entry<Integer, List<ItemStack>> entry : slotSuggestions.entrySet()) {
            int inputSlot = entry.getKey();
            List<ItemStack> validInputs = entry.getValue();
            if (validInputs.isEmpty() || !((AbstractCompressedMenu)this.menu).getSlot(inputSlot).getItem().isEmpty()) continue;
            long rotationIndex = System.currentTimeMillis() / 1000L % (long)validInputs.size();
            ItemStack rotatingInput = validInputs.get((int)rotationIndex);
            int slotX = this.leftPos + ((AbstractCompressedMenu)this.menu).getSlotPositionX(inputSlot);
            int slotY = this.topPos + ((AbstractCompressedMenu)this.menu).getSlotPositionY(inputSlot);
            this.renderTransparentBackground(guiGraphics, slotX, slotY);
            this.renderTintedFakeItem(guiGraphics, rotatingInput, slotX, slotY);
        }
    }

    private void renderTransparentBackground(GuiGraphics guiGraphics, int x, int y) {
        int backgroundColor = -2013265920;
        guiGraphics.fill(x, y, x + 16, y + 16, backgroundColor);
    }

    private void renderTintedFakeItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float scale = 0.8f;
        float xOffset = (float)x + (1.0f - scale) * 8.0f;
        float yOffset = (float)y + (1.0f - scale) * 8.0f;
        poseStack.translate(xOffset, yOffset, 0.0f);
        poseStack.scale(scale, scale, scale);
        guiGraphics.renderItem(itemStack, 0, 0);
        guiGraphics.renderItemDecorations(this.font, itemStack, 0, 0);
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((AbstractCompressedMenu)this.menu).hasXPWaiting()) {
            this.XP_BOTTLE.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        List<ButtonDirection> buttons = List.of(new ButtonDirection(this.toggleUpSide, Direction.UP), new ButtonDirection(this.toggleDownSide, Direction.DOWN), new ButtonDirection(this.toggleCenterSide, ((AbstractCompressedMenu)this.menu).getFacing()), new ButtonDirection(this.toggleLeftSide, ((AbstractCompressedMenu)this.menu).getFacing().getClockWise()), new ButtonDirection(this.toggleRightSide, ((AbstractCompressedMenu)this.menu).getFacing().getCounterClockWise()), new ButtonDirection(this.toggleBackSide, ((AbstractCompressedMenu)this.menu).getFacing().getOpposite()));
        for (ButtonDirection buttonDirection : buttons) {
            if (!this.isMouseOverButton(buttonDirection.button, (int)mouseX, (int)mouseY)) continue;
            this.handleSideButtonClick(buttonDirection.direction, button);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void handleSideButtonClick(Direction side, int button) {
        if (AbstractCompressedScreen.hasShiftDown()) {
            Messages.sendToServer(new SetSideIO(side, true));
            return;
        }
        if (button == 0) {
            Messages.sendToServer(new SetSideIO(side, false));
        } else if (button == 1) {
            Messages.sendToServer(new SetSideIOReverse(side));
        }
    }

    protected int getXStart(String tierID) {
        boolean isCrusher = this.type.contains("crusher");
        return switch (tierID) {
            case "compressed" -> {
                if (isCrusher) {
                    yield 69;
                }
                yield 71;
            }
            case "double_compressed" -> {
                if (isCrusher) {
                    yield 63;
                }
                yield 65;
            }
            case "triple_compressed" -> {
                if (isCrusher) {
                    yield 42;
                }
                yield 44;
            }
            default -> throw new IllegalStateException("Unexpected value: " + tierID);
        };
    }

    protected String blockName(String type) {
        return type.equals("blast") ? "furnace" : (type.equals("powered_blast") ? "powered_furnace" : type);
    }

    protected Button createButton(String label, int x, int y, int width, int height, Button.OnPress action) {
        return (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)label), action).bounds(x, y, width, height).build());
    }

    private void setSideButtonsVisibility(boolean visible) {
        if (CompressedFurnace.AUTO_EXPORT) {
            this.toggleAutoExport.visible = visible;
        }
        this.toggleUpSide.visible = visible;
        this.toggleLeftSide.visible = visible;
        this.toggleCenterSide.visible = visible;
        this.toggleRightSide.visible = visible;
        this.toggleBackSide.visible = visible;
        this.toggleDownSide.visible = visible;
        this.toggleReset.visible = visible;
    }

    private void updateButtonStyle(Button button, String label, SideConfigHelper.SlotType type) {
        button.setMessage((Component)Component.literal((String)label).withStyle(style -> switch (type) {
            case SideConfigHelper.SlotType.INPUT -> style.withColor(ChatFormatting.GREEN);
            case SideConfigHelper.SlotType.OUTPUT -> style.withColor(ChatFormatting.DARK_RED);
            case SideConfigHelper.SlotType.IO -> style.withColor(ChatFormatting.DARK_PURPLE);
            case SideConfigHelper.SlotType.FUEL -> style.withColor(ChatFormatting.YELLOW);
            default -> style.withColor(ChatFormatting.WHITE);
        }));
    }

    private void updateAutoSplitButtonStyle() {
        this.toggleAutoSplit.setMessage((Component)Component.literal((String)"S").withStyle(style -> style.withColor(((AbstractCompressedMenu)this.menu).autoSplitEnabled() ? ChatFormatting.GREEN : ChatFormatting.DARK_RED)));
    }

    private void updateAutoExportButtonStyle() {
        this.toggleAutoExport.setMessage((Component)Component.literal((String)"E").withStyle(style -> style.withColor(((AbstractCompressedMenu)this.menu).exportEnabled() ? ChatFormatting.GREEN : ChatFormatting.DARK_RED)));
    }

    private void renderXPTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.XP_BOTTLE.active = ((AbstractCompressedMenu)this.menu).hasXPWaiting();
        if (((AbstractCompressedMenu)this.menu).hasXPWaiting() && this.XP_BOTTLE.isMouseOver(mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, List.of(Component.literal((String)"XP Available").getVisualOrderText(), Component.literal((String)"Click to collect. ").getVisualOrderText()), DefaultTooltipPositioner.INSTANCE, mouseX, mouseY);
        }
    }

    protected ResourceLocation getTierGUITexture() {
        return switch (this.teirId) {
            case "compressed" -> this.GUI;
            case "double_compressed" -> this.DOUBLE_GUI;
            case "triple_compressed" -> this.TRIPLE_GUI;
            default -> throw new IllegalStateException("Unexpected tier: " + this.teirId);
        };
    }

    private boolean getSideActive(SideConfigHelper.SlotType sideType) {
        return sideType != SideConfigHelper.SlotType.NONE;
    }

    private int getBaseY(String type) {
        return type.contains("crusher") ? 30 : 27;
    }

    private record ButtonDirection(Button button, Direction direction) {
    }
}

