/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class GeneratorRecipe
implements Recipe<SingleRecipeInput> {
    public int energy;
    public Ingredient ingredient;

    public GeneratorRecipe(int energy, Ingredient ingredient) {
        this.energy = energy;
        this.ingredient = ingredient;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean isIncomplete() {
        return Arrays.stream(this.ingredient.getItems()).toList().getFirst().isEmpty();
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean matches(SingleRecipeInput inv, Level p_44003_) {
        return this.ingredient.test(inv.item());
    }

    public ItemStack assemble(SingleRecipeInput p_343633_, HolderLookup.Provider p_332698_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_331967_) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MultiFurnaceTieredItems.GENERATOR_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)MultiFurnaceTieredItems.GENERATOR_RECIPE_TYPE.get();
    }

    public static class Serializer<T extends GeneratorRecipe>
    implements RecipeSerializer<GeneratorRecipe> {
        private static final MapCodec<GeneratorRecipe> codec = RecordCodecBuilder.mapCodec(h -> h.group((App)Codec.INT.optionalFieldOf("energy", (Object)0).forGetter(j -> j.energy), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient)).apply((Applicative)h, GeneratorRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, GeneratorRecipe> streamCodec = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static GeneratorRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            int energy = buf.readVarInt();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            return new GeneratorRecipe(energy, ingredient);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, GeneratorRecipe recipe) {
            buf.writeVarInt(recipe.energy);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.ingredient);
        }

        public MapCodec<GeneratorRecipe> codec() {
            return codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GeneratorRecipe> streamCodec() {
            return streamCodec;
        }
    }
}

