/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.biorfn.compressedfurnace.recipes.CrusherRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public record CrusherRecipeSerializer(MapCodec<CrusherRecipe> codec) implements RecipeSerializer<CrusherRecipe>
{
    public StreamCodec<RegistryFriendlyByteBuf, CrusherRecipe> streamCodec() {
        return StreamCodec.of(this::encodeRecipe, this::decodeRecipe);
    }

    private void encodeRecipe(RegistryFriendlyByteBuf buffer, CrusherRecipe recipe) {
        Objects.requireNonNull(recipe, "Recipe cannot be null during encoding.");
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)recipe.category());
        this.serializeIngredient(buffer, (Ingredient)recipe.getIngredients().getFirst());
        this.serializeItemStack(buffer, recipe.getResultItem((HolderLookup.Provider)buffer.registryAccess()));
        buffer.writeFloat(recipe.getExperience());
        buffer.writeInt(recipe.getCookingTime());
    }

    private CrusherRecipe decodeRecipe(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        CookingBookCategory category = (CookingBookCategory)buffer.readEnum(CookingBookCategory.class);
        Ingredient ingredient = this.deserializeIngredient(buffer);
        ItemStack result = this.deserializeItemStack(buffer);
        float experience = buffer.readFloat();
        int cookingTime = buffer.readInt();
        return new CrusherRecipe(group, category, ingredient, result, experience, cookingTime);
    }

    private void serializeIngredient(RegistryFriendlyByteBuf buffer, Ingredient ingredient) {
        JsonElement jsonElement = (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).resultOrPartial(error -> {
            throw new RuntimeException("Failed to serialize Ingredient: " + error);
        }).orElseThrow(() -> new IllegalStateException("Unexpected error in Ingredient serialization"));
        buffer.writeUtf(jsonElement.toString());
    }

    private Ingredient deserializeIngredient(RegistryFriendlyByteBuf buffer) {
        String rawJson = buffer.readUtf();
        if (rawJson.isBlank()) {
            throw new IllegalArgumentException("Received empty JSON for Ingredient deserialization!");
        }
        return (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.parse((String)rawJson)).resultOrPartial(error -> {
            throw new RuntimeException("Failed to decode Ingredient: " + error);
        }).orElseThrow(() -> new IllegalStateException("Ingredient decoding resulted in an empty Optional!"));
    }

    private void serializeItemStack(RegistryFriendlyByteBuf buffer, ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            throw new IllegalArgumentException("ItemStack cannot be null or empty during serialization!");
        }
        JsonElement jsonElement = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)itemStack).resultOrPartial(error -> {
            throw new RuntimeException("Failed to serialize ItemStack: " + error);
        }).orElseThrow(() -> new IllegalStateException("Unexpected error during ItemStack serialization!"));
        buffer.writeUtf(jsonElement.toString());
    }

    private ItemStack deserializeItemStack(RegistryFriendlyByteBuf buffer) {
        String rawJson = buffer.readUtf();
        if (rawJson.isBlank()) {
            throw new IllegalArgumentException("Received empty JSON for ItemStack deserialization!");
        }
        try {
            JsonObject json = GsonHelper.parse((String)rawJson);
            if (json.has("item") && !json.has("id")) {
                json.add("id", json.remove("item"));
            }
            if (!json.has("id")) {
                throw new JsonParseException("ItemStack JSON must contain an 'id' field!");
            }
            return (ItemStack)ItemStack.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> {
                throw new RuntimeException("Failed to deserialize ItemStack: " + error);
            }).orElseThrow(() -> new IllegalStateException("ItemStack decoding resulted in an empty result!"));
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Invalid ItemStack format: Malformed JSON encountered.", e);
        }
    }
}

