/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.biorfn.compressedfurnace.recipes.CrusherRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CrusherRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final CookingBookCategory bookCategory;
    private final Ingredient input;
    private final Item result;
    private final ItemStack stackResult;
    private final float experience;
    private final int cookingTime;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final AbstractCookingRecipe.Factory<?> factory;

    public CrusherRecipeBuilder(Ingredient input, ItemLike result, float experience, int cookingTime, AbstractCookingRecipe.Factory<?> factory, RecipeCategory category, CookingBookCategory cookingBookCategory) {
        this(input, new ItemStack(result), experience, cookingTime, factory, category, cookingBookCategory);
    }

    public CrusherRecipeBuilder(Ingredient input, ItemLike result, int count, float experience, int cookingTime, AbstractCookingRecipe.Factory<?> factory, RecipeCategory category, CookingBookCategory cookingBookCategory) {
        this(input, new ItemStack(result, count), experience, cookingTime, factory, category, cookingBookCategory);
    }

    public CrusherRecipeBuilder(Ingredient input, ItemStack result, float experience, int cookingTime, AbstractCookingRecipe.Factory<?> factory, RecipeCategory category, CookingBookCategory cookingBookCategory) {
        this.category = category;
        this.bookCategory = cookingBookCategory;
        this.result = result.getItem();
        this.stackResult = result;
        this.input = input;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.factory = factory;
    }

    public static CrusherRecipeBuilder crusher(Ingredient ingredient, ItemLike result, float xp, int cookTime) {
        return new CrusherRecipeBuilder(ingredient, result, xp, cookTime, CrusherRecipe::new, RecipeCategory.MISC, CookingBookCategory.MISC);
    }

    public static CrusherRecipeBuilder crusher(Ingredient ingredient, ItemLike result, int count, float xp, int cookTime) {
        return new CrusherRecipeBuilder(ingredient, result, count, xp, cookTime, CrusherRecipe::new, RecipeCategory.MISC, CookingBookCategory.MISC);
    }

    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        this.criteria.put(s, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        this.group = s;
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        Map<String, Criterion<?>> var10000 = this.criteria;
        Objects.requireNonNull(advancement$builder);
        var10000.forEach((key, value) -> advancement$builder.addCriterion((String)key, (Criterion)value));
        AbstractCookingRecipe abstractcookingrecipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.bookCategory, this.input, this.stackResult, this.experience, this.cookingTime);
        recipeOutput.accept(id, (Recipe)abstractcookingrecipe, advancement$builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    private void ensureValid(ResourceLocation recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("Recipe " + String.valueOf(recipeId) + " has no way of being unlocked! Add a criterion.");
        }
    }

    public String toString() {
        return super.toString();
    }
}

