/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.menu.powered;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.biorfn.compressedfurnace.entity.powered.AbstractCompressedPoweredEntityBlock;
import net.biorfn.compressedfurnace.menu.AbstractCompressedMenu;
import net.biorfn.compressedfurnace.menu.slots.InputSlot;
import net.biorfn.compressedfurnace.menu.slots.ResultSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractCompressedPoweredMenu
extends AbstractCompressedMenu {
    public final int INPUT0 = 0;
    public final int OUTPUT0 = 1;
    public final int INPUT1 = 2;
    public final int OUTPUT1 = 3;
    public final int INPUT2 = 4;
    public final int OUTPUT2 = 5;
    public final int INPUT3 = 6;
    public final int OUTPUT3 = 7;
    public final int INPUT4 = 8;
    public final int OUTPUT4 = 9;
    public final int INPUT5 = 10;
    public final int OUTPUT5 = 11;

    public AbstractCompressedPoweredMenu(MenuType<?> menuType, int containerId, Level level, Inventory playerInventory, String tierID, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        this(menuType, containerId, level, playerInventory, tierID, (ContainerData)new SimpleContainerData(15), (ContainerData)new SimpleContainerData(9), recipeType);
    }

    public AbstractCompressedPoweredMenu(MenuType<?> menuType, int containerId, Level level, Inventory playerInventory, String tierID, ContainerData data, ContainerData data1, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(menuType, containerId, level, playerInventory, tierID, data, data1, recipeType);
        Player player = playerInventory.player;
        BlockHitResult blockHitResult = (BlockHitResult)player.pick(5.0, 0.0f, false);
        BlockPos pos = blockHitResult.getBlockPos();
        this.container = (AbstractCompressedPoweredEntityBlock)level.getBlockEntity(pos);
    }

    @Override
    public AbstractCompressedPoweredEntityBlock getBlockEntity() {
        return (AbstractCompressedPoweredEntityBlock)this.container;
    }

    @Override
    protected void addTierSpecificSlots(Container container, Inventory playerInventory, String tierID) {
        if (tierID != null) {
            switch (tierID) {
                case "compressed": {
                    this.addSlot(new InputSlot(container, 0, 70, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 1, 70, 55));
                    this.addSlot(new InputSlot(container, 2, 91, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 3, 91, 55));
                    break;
                }
                case "double_compressed": {
                    this.addSlot(new InputSlot(container, 0, 64, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 1, 64, 55));
                    this.addSlot(new InputSlot(container, 2, 85, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 3, 85, 55));
                    this.addSlot(new InputSlot(container, 4, 106, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 5, 106, 55));
                    this.addSlot(new InputSlot(container, 6, 127, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 7, 127, 55));
                    break;
                }
                case "triple_compressed": {
                    this.addSlot(new InputSlot(container, 0, 43, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 1, 43, 55));
                    this.addSlot(new InputSlot(container, 2, 64, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 3, 64, 55));
                    this.addSlot(new InputSlot(container, 4, 85, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 5, 85, 55));
                    this.addSlot(new InputSlot(container, 6, 106, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 7, 106, 55));
                    this.addSlot(new InputSlot(container, 8, 127, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 9, 127, 55));
                    this.addSlot(new InputSlot(container, 10, 148, 6));
                    this.addSlot(new ResultSlot(playerInventory.player, container, 11, 148, 55));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tier: " + tierID);
                }
            }
        }
    }

    public int getEnergy() {
        return this.data.get(0);
    }

    public int getMaxEnergy() {
        return this.data.get(1);
    }

    @Override
    public Map<Integer, List<ItemStack>> getSlotInputSuggestions() {
        HashMap<Integer, List<ItemStack>> slotSuggestions = new HashMap<Integer, List<ItemStack>>();
        int[] inputSlots = this.SlotForInput(this.tierID);
        int[] outputSlots = this.SlotForOutput(this.tierID);
        for (int i = 0; i < Math.min(inputSlots.length, outputSlots.length); ++i) {
            int inputSlot = inputSlots[i];
            int outputSlot = outputSlots[i];
            ItemStack outputStack = this.getSlot(outputSlot).getItem();
            if (outputStack.isEmpty()) continue;
            List<ItemStack> validInputs = this.getValidInputsForOutput(outputStack);
            slotSuggestions.put(inputSlot, validInputs);
        }
        return slotSuggestions;
    }

    @Override
    public int[] SlotForInput(String tierID) {
        int[] nArray;
        switch (tierID) {
            case "compressed": {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 2;
                break;
            }
            case "double_compressed": {
                int[] nArray3 = new int[4];
                nArray3[0] = 0;
                nArray3[1] = 2;
                nArray3[2] = 4;
                nArray = nArray3;
                nArray3[3] = 6;
                break;
            }
            case "triple_compressed": {
                int[] nArray4 = new int[6];
                nArray4[0] = 0;
                nArray4[1] = 2;
                nArray4[2] = 4;
                nArray4[3] = 6;
                nArray4[4] = 8;
                nArray = nArray4;
                nArray4[5] = 10;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + tierID);
            }
        }
        return nArray;
    }

    @Override
    public int[] SlotForOutput(String tierID) {
        int[] nArray;
        switch (tierID) {
            case "compressed": {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 3;
                break;
            }
            case "double_compressed": {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[1] = 3;
                nArray3[2] = 5;
                nArray = nArray3;
                nArray3[3] = 7;
                break;
            }
            case "triple_compressed": {
                int[] nArray4 = new int[6];
                nArray4[0] = 1;
                nArray4[1] = 3;
                nArray4[2] = 5;
                nArray4[3] = 7;
                nArray4[4] = 9;
                nArray = nArray4;
                nArray4[5] = 11;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + tierID);
            }
        }
        return nArray;
    }

    @Override
    public int getSlotPositionX(int slot) {
        return switch (this.tierID) {
            case "compressed" -> {
                if (slot == 0) {
                    yield 70;
                }
                yield 91;
            }
            case "double_compressed" -> {
                if (slot == 0) {
                    yield 64;
                }
                if (slot == 2) {
                    yield 85;
                }
                if (slot == 4) {
                    yield 106;
                }
                yield 127;
            }
            case "triple_compressed" -> {
                if (slot == 0) {
                    yield 43;
                }
                if (slot == 2) {
                    yield 64;
                }
                if (slot == 4) {
                    yield 85;
                }
                if (slot == 6) {
                    yield 106;
                }
                if (slot == 8) {
                    yield 127;
                }
                yield 148;
            }
            default -> 0;
        };
    }
}

