/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.biorfn.compressedfurnace.recipes.CrusherRecipe;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RecipeCatigoryCrusher
implements IRecipeCategory<CrusherRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"category_crusher");
    public IGuiHelper guiHelper;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;

    public RecipeCatigoryCrusher(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.staticFlame = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"textures/gui/jei_crush.png"), 68, 14, 18, 16);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CrusherRecipe> getRecipeType() {
        return MultiFurnaceTieredItems.RecipeTypes.CRUSHER_RECIPE_JEI;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.compressedfurnace.crusher");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_CRUSHER.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrusherRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 18).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 17).addItemStack(recipe.getResultItem(null));
    }

    public int getWidth() {
        return 68;
    }

    public int getHeight() {
        return 42;
    }

    public void draw(CrusherRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ResourceLocation backgroundTexture = CallConstants.getLocation("textures/gui/jei_crush.png");
        guiGraphics.blit(backgroundTexture, 0, 0, 0, 0, this.getWidth(), this.getHeight());
        this.animatedFlame.draw(guiGraphics, 24, 17);
    }

    public boolean isHandled(CrusherRecipe recipe) {
        return super.isHandled((Object)recipe);
    }

    @Nullable
    public ResourceLocation getRegistryName(CrusherRecipe recipe) {
        return super.getRegistryName((Object)recipe);
    }
}

