/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipe;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.biorfn.compressedfurnace.util.CallConstants;
import net.biorfn.compressedfurnace.util.StringHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RecipeCategoryGenerator
implements IRecipeCategory<GeneratorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"category_generator");
    public IGuiHelper guiHelper;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;
    protected final IDrawableStatic staticEnergy;
    protected final IDrawableAnimated animatedEnergy;
    protected final IDrawableStatic staticArrow;
    protected final IDrawableAnimated animatedArrow;

    public RecipeCategoryGenerator(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.staticFlame = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"textures/gui/jei_gen.png"), 68, 0, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.staticEnergy = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"textures/gui/jei_gen.png"), 82, 0, 14, 42);
        this.animatedEnergy = guiHelper.createAnimatedDrawable(this.staticEnergy, 300, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.staticArrow = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"compressedfurnace", (String)"textures/gui/jei_gen.png"), 97, 0, 24, 16);
        this.animatedArrow = guiHelper.createAnimatedDrawable(this.staticArrow, 300, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<GeneratorRecipe> getRecipeType() {
        return MultiFurnaceTieredItems.RecipeTypes.GENERATOR_RECIPE_JEI;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.compressedfurnace.generator");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MultiFurnaceTieredItems.TRIPLE_COMPRESSED_FURNACE.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeneratorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 18).addIngredients((Ingredient)recipe.getIngredients().get(0));
    }

    public int getWidth() {
        return 68;
    }

    public int getHeight() {
        return 42;
    }

    public void draw(GeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ResourceLocation backgroundTexture = CallConstants.getLocation("textures/gui/jei_gen.png");
        guiGraphics.blit(backgroundTexture, 0, 0, 0, 0, this.getWidth(), this.getHeight());
        this.animatedFlame.draw(guiGraphics, 1, 1);
        this.animatedEnergy.draw(guiGraphics, 54, 0);
        this.animatedArrow.draw(guiGraphics, 24, 13);
    }

    public void getTooltip(ITooltipBuilder tooltip, GeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 55.0 && mouseX <= 68.0 && mouseY >= 1.0 && mouseY <= 42.0) {
            tooltip.add((FormattedText)Component.literal((String)StringHelper.displayEnergy(recipe.getEnergy()).get(0)));
        }
    }

    public boolean isHandled(GeneratorRecipe recipe) {
        return super.isHandled((Object)recipe);
    }

    @Nullable
    public ResourceLocation getRegistryName(GeneratorRecipe recipe) {
        return super.getRegistryName((Object)recipe);
    }
}

