/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.entity.powered;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.biorfn.compressedfurnace.blocks.powered.AbstractCompressedPoweredBlock;
import net.biorfn.compressedfurnace.config.Config;
import net.biorfn.compressedfurnace.energy.FEnergyStorage;
import net.biorfn.compressedfurnace.entity.AbstractCompressedEntityBlock;
import net.biorfn.compressedfurnace.util.RecipeValidation;
import net.biorfn.compressedfurnace.util.entitiy.BurnUtil;
import net.biorfn.compressedfurnace.util.entitiy.CookingState;
import net.biorfn.compressedfurnace.util.entitiy.PSideConfigHelper;
import net.biorfn.compressedfurnace.util.entitiy.SlotManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompressedPoweredEntityBlock
extends AbstractCompressedEntityBlock
implements IEnergyStorage {
    private static final int INPUT0 = 0;
    private static final int INPUT1 = 2;
    private static final int INPUT2 = 4;
    private static final int INPUT3 = 6;
    private static final int INPUT4 = 8;
    private static final int INPUT5 = 10;
    private static final int[] INPUTSLOTS = new int[]{0, 2, 4, 6, 8, 10};
    private static final int ENERGY_USAGE_PER_TICK = 20;
    private int initializationDelay = 10;
    public long lastGameTickEnergyUpdated;
    private boolean isLit = false;
    public final FEnergyStorage energyStorage;
    private final PSideConfigHelper pSideConfigHelper;

    public AbstractCompressedPoweredEntityBlock(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, String tierId, RecipeType<? extends AbstractCookingRecipe> recipeType, String type) {
        super(tileEntityTypeIn, pos, state, tierId, recipeType, type);
        this.items = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
        this.SLOTS_FOR_INPUT = this.assignSlots(this.tierID, true);
        this.SLOTS_FOR_OUTPUT = this.assignSlots(this.tierID, false);
        this.SLOTS_FOR_DOWN = this.assignSlots(this.tierID, false);
        this.SLOTS_FOR_SIDES = this.assignSlots(this.tierID, true);
        this.pSideConfigHelper = new PSideConfigHelper();
        this.energyStorage = this.createEnergyStorage(tierId);
        this.dataAccess = new ContainerData(){

            public int get(int i) {
                boolean isProgress;
                switch (i) {
                    case 0: {
                        return AbstractCompressedPoweredEntityBlock.this.energyStorage.getEnergyStored();
                    }
                    case 1: {
                        return AbstractCompressedPoweredEntityBlock.this.energyStorage.getMaxEnergyStored();
                    }
                    case 14: {
                        return AbstractCompressedPoweredEntityBlock.this.isLit ? 1 : 0;
                    }
                }
                int slotIndex = (i - 2) / 2;
                boolean bl = isProgress = i % 2 == 0;
                if (slotIndex >= 0 && slotIndex < INPUTSLOTS.length) {
                    CookingState state = (CookingState)AbstractCompressedPoweredEntityBlock.this.cookingStateBySlot.get(INPUTSLOTS[slotIndex]);
                    return state != null ? (isProgress ? state.getProgress() : state.getTotalTime()) : 0;
                }
                return 0;
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        AbstractCompressedPoweredEntityBlock.this.energyStorage.setEnergy(value);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 14: {
                        AbstractCompressedPoweredEntityBlock.this.isLit = value == 1;
                        break;
                    }
                    default: {
                        boolean isProgress;
                        int slotIndex = (i - 2) / 2;
                        boolean bl = isProgress = i % 2 == 0;
                        if (slotIndex < 0 || slotIndex >= INPUTSLOTS.length) break;
                        CookingState state = AbstractCompressedPoweredEntityBlock.this.cookingStateBySlot.computeIfAbsent(INPUTSLOTS[slotIndex], key -> new CookingState(0, AbstractCompressedPoweredEntityBlock.this.DEFAULT_COOK_TIME));
                        if (isProgress) {
                            state.setProgress(value);
                            break;
                        }
                        state.setTotalTime(value);
                    }
                }
            }

            public int getCount() {
                return 15;
            }
        };
        for (int inputSlot : INPUTSLOTS) {
            this.cookingStateBySlot.put(inputSlot, CookingState.createWithTier(tierId, this.DEFAULT_COOK_TIME));
        }
    }

    @Override
    protected int sideTypeToIndex(Direction side) {
        return this.pSideConfigHelper.sideTypeToIndex(side);
    }

    @Override
    protected void setSlotType(Direction side, int index) {
        this.pSideConfigHelper.setSlotType(side, index);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.energyStorage.setEnergy(tag.getInt("Energy"));
        this.initializationDelay = tag.getInt("InitializationDelay");
        this.lastGameTickEnergyUpdated = 0L;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Energy", this.energyStorage.getEnergyStored());
        tag.putInt("InitializationDelay", this.initializationDelay);
    }

    @Override
    protected void loadCookingState(CompoundTag tag) {
        CompoundTag cookingStateTag = tag.getCompound("CookingStateBySlot");
        for (String key : cookingStateTag.getAllKeys()) {
            int slot = Integer.parseInt(key);
            CompoundTag stateTag = cookingStateTag.getCompound(key);
            CookingState cookingState = new CookingState(stateTag.getInt("Progress"), stateTag.getInt("TotalTime"));
            if (cookingState.getTotalTime() > 300) {
                int correctedTime = CookingState.createWithTier(this.tierID, this.DEFAULT_COOK_TIME).getTotalTime();
                cookingState.setTotalTime(correctedTime);
                cookingState.resetProgress();
            }
            this.cookingStateBySlot.put(slot, cookingState);
        }
    }

    @Override
    protected void loadSide(CompoundTag tag) {
        this.pSideConfigHelper.loadFromNBT(tag);
    }

    @Override
    protected void saveSide(CompoundTag tag) {
        this.pSideConfigHelper.saveToNBT(tag);
    }

    private static boolean canProOut(AbstractCompressedPoweredEntityBlock blockEntity) {
        int[] inputSlots = blockEntity.SLOTS_FOR_INPUT;
        int[] outputSlots = blockEntity.SLOTS_FOR_OUTPUT;
        boolean canAnySlotProcess = false;
        for (int i = 0; i < inputSlots.length; ++i) {
            boolean hasEnoughSpace;
            int inputSlot = inputSlots[i];
            int outputSlot = outputSlots[i];
            CookingState cookingState = (CookingState)blockEntity.cookingStateBySlot.get(inputSlot);
            ItemStack inputStack = (ItemStack)blockEntity.items.get(inputSlot);
            ItemStack outputStack = (ItemStack)blockEntity.items.get(outputSlot);
            if (inputStack.isEmpty()) continue;
            assert (blockEntity.level != null);
            RecipeHolder recipeHolder = blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputStack), blockEntity.level).orElse(null);
            if (recipeHolder == null) continue;
            ItemStack resultStack = ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)blockEntity.level.registryAccess());
            boolean isSameOutputItem = outputStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack);
            boolean bl = hasEnoughSpace = outputStack.isEmpty() || outputStack.isStackable() && outputStack.getCount() + resultStack.getCount() <= blockEntity.getMaxStackSize();
            if (isSameOutputItem && hasEnoughSpace) {
                canAnySlotProcess = true;
            }
            if (isSameOutputItem) continue;
            cookingState.resetProgress();
        }
        return canAnySlotProcess;
    }

    protected void checkExportP(AbstractCompressedPoweredEntityBlock blockEntity, Level level) {
        int[] outputSlots;
        for (int outputSlot : outputSlots = blockEntity.SLOTS_FOR_OUTPUT) {
            ItemStack outputStack = (ItemStack)blockEntity.items.get(outputSlot);
            if (outputStack.isEmpty() || !blockEntity.isExportEnabled() || level.isClientSide) continue;
            for (Direction direction : Direction.values()) {
                blockEntity.transferItemsOut(direction, level.getGameTime());
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractCompressedPoweredEntityBlock blockEntity) {
        boolean hadEnergy = blockEntity.isLit;
        blockEntity.updateAllowedItems(blockEntity.SLOTS_FOR_INPUT.length);
        if (blockEntity.isAutoSplitEnabled()) {
            blockEntity.split(true, 0, blockEntity.SLOTS_FOR_INPUT.length);
        }
        AbstractCompressedPoweredEntityBlock.reciveEnergy(level, pos, blockEntity);
        boolean bl = blockEntity.isLit = blockEntity.energyStorage.getEnergyStored() >= 20 && RecipeValidation.hasValidRecipe(level, INPUTSLOTS, (RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe>)blockEntity.quickCheck, (List<ItemStack>)blockEntity.items) && AbstractCompressedPoweredEntityBlock.canProOut(blockEntity);
        if (blockEntity.isLit != hadEnergy) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AbstractCompressedPoweredBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit)), 3);
        }
        blockEntity.checkExportP(blockEntity, level);
        if (blockEntity.isLit) {
            inputSlots = blockEntity.SLOTS_FOR_INPUT;
            int[] outputSlots = blockEntity.SLOTS_FOR_OUTPUT;
            blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergyStored() - 20);
            for (int i = 0; i < inputSlots.length; ++i) {
                inputSlot = inputSlots[i];
                int outputSlot = outputSlots[i];
                cookingState = (CookingState)blockEntity.cookingStateBySlot.get(inputSlot);
                ItemStack inputStack = (ItemStack)blockEntity.items.get(inputSlot);
                ItemStack outputStack = (ItemStack)blockEntity.items.get(outputSlot);
                if (!inputStack.isEmpty()) {
                    RecipeHolder recipeHolder = blockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(inputStack), level).orElse(null);
                    if (recipeHolder != null) {
                        boolean hasEnoughSpace;
                        ItemStack resultStack = ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(inputStack), (HolderLookup.Provider)level.registryAccess());
                        boolean isSameOutputItem = outputStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack);
                        boolean bl2 = hasEnoughSpace = outputStack.isEmpty() || outputStack.isStackable() && outputStack.getCount() + resultStack.getCount() <= blockEntity.getMaxStackSize();
                        if (isSameOutputItem && !hasEnoughSpace) continue;
                        if (!isSameOutputItem) {
                            cookingState.resetProgress();
                            continue;
                        }
                        cookingState.incrementProgress();
                        if (!cookingState.isComplete()) continue;
                        BurnUtil.finishProcessing(level.registryAccess(), recipeHolder, (NonNullList<ItemStack>)blockEntity.items, inputSlot, outputSlot, blockEntity.getMaxStackSize(), blockEntity.isCursher() ? null : blockEntity.extraItemManager, blockEntity.tierID, level, blockEntity.worldPosition, blockEntity.cookingStateBySlot, blockEntity.isCursher(), blockEntity.isCursher());
                        cookingState.resetProgress();
                        blockEntity.setRecipeUsedForSlot(recipeHolder, outputSlot);
                        continue;
                    }
                    cookingState.resetProgress();
                    continue;
                }
                cookingState.resetProgress();
            }
        } else {
            int[] nArray = inputSlots = blockEntity.SLOTS_FOR_INPUT;
            int n = nArray.length;
            for (inputSlot = 0; inputSlot < n; ++inputSlot) {
                int inputSlot = nArray[inputSlot];
                cookingState = (CookingState)blockEntity.cookingStateBySlot.get(inputSlot);
                if (cookingState == null) continue;
                cookingState.resetProgress();
            }
        }
        for (int outputSlot : blockEntity.SLOTS_FOR_OUTPUT) {
            ItemStack outputStack = (ItemStack)blockEntity.items.get(outputSlot);
            if (outputStack.isEmpty() && !blockEntity.isHasUnclaimedXP()) {
                Object2IntOpenHashMap recipesForSlot = (Object2IntOpenHashMap)blockEntity.recipesUsedPerSlot.get(outputSlot);
                if (recipesForSlot == null || recipesForSlot.isEmpty()) continue;
                blockEntity.setHasUnclaimedXP(true);
                blockEntity.trackedSlotForXP = outputSlot;
                break;
            }
            if (outputStack.isEmpty() || !blockEntity.isHasUnclaimedXP() || blockEntity.trackedSlotForXP != outputSlot) continue;
            blockEntity.setHasUnclaimedXP(false);
            blockEntity.trackedSlotForXP = -1;
            break;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    protected static void reciveEnergy(Level level, BlockPos pos, AbstractCompressedPoweredEntityBlock blockEntity) {
        if (blockEntity.energyStorage.getEnergyStored() >= blockEntity.energyStorage.getMaxEnergyStored()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            IEnergyStorage energyNeighbor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite());
            if (energyNeighbor == null || !energyNeighbor.canExtract()) continue;
            int energyToPull = Math.min(blockEntity.energyStorage.getMaxReceive(), Math.min(energyNeighbor.extractEnergy(blockEntity.energyStorage.getMaxReceive(), true), blockEntity.energyStorage.getMaxEnergyStored() - blockEntity.energyStorage.getEnergyStored()));
            int energyExtracted = energyNeighbor.extractEnergy(energyToPull, false);
            blockEntity.energyStorage.receiveEnergy(energyExtracted, false);
            if (blockEntity.energyStorage.getEnergyStored() >= blockEntity.energyStorage.getMaxEnergyStored()) break;
        }
    }

    protected FEnergyStorage createEnergyStorage(String tierID) {
        int capacity = switch (tierID) {
            case "compressed" -> (Integer)Config.compressedEnergyCapacity.get() * 2;
            case "double_compressed" -> (Integer)Config.doubleCompressedEnergyCapacity.get() * 2;
            case "triple_compressed" -> (Integer)Config.tripleCompressedEnergyCapacity.get() * 2;
            default -> 0;
        };
        int maxTransfer = switch (tierID) {
            case "compressed" -> (Integer)Config.compressedMaxTransferRate.get();
            case "double_compressed" -> (Integer)Config.doubleCompressedMaxTransferRate.get();
            case "triple_compressed" -> (Integer)Config.tripleCompressedMaxTransferRate.get();
            default -> 0;
        };
        return new FEnergyStorage(capacity, maxTransfer, maxTransfer, 0){

            @Override
            protected void onEnergyChanged() {
                if (AbstractCompressedPoweredEntityBlock.this.level != null && AbstractCompressedPoweredEntityBlock.this.level.getBlockEntity(AbstractCompressedPoweredEntityBlock.this.getBlockPos()) != null) {
                    if (AbstractCompressedPoweredEntityBlock.this.lastGameTickEnergyUpdated <= 0L) {
                        AbstractCompressedPoweredEntityBlock.this.setChanged();
                        AbstractCompressedPoweredEntityBlock.this.lastGameTickEnergyUpdated = AbstractCompressedPoweredEntityBlock.this.level.getGameTime();
                    } else if (AbstractCompressedPoweredEntityBlock.this.level.getGameTime() - AbstractCompressedPoweredEntityBlock.this.lastGameTickEnergyUpdated >= 20L) {
                        AbstractCompressedPoweredEntityBlock.this.setChanged();
                        AbstractCompressedPoweredEntityBlock.this.lastGameTickEnergyUpdated = AbstractCompressedPoweredEntityBlock.this.level.getGameTime();
                    }
                }
            }

            public boolean canReceive() {
                return true;
            }

            public boolean canExtract() {
                return false;
            }
        };
    }

    @Override
    protected int[] assignSlots(String tierID, boolean input) {
        return SlotManager.assignPoweredSlots(tierID, input);
    }

    @Override
    public int[] getSlotsForFace(Direction side) {
        PSideConfigHelper.SlotType slotType = this.pSideConfigHelper.getSlotType(side);
        if (slotType == PSideConfigHelper.SlotType.INPUT) {
            return this.SLOTS_FOR_INPUT;
        }
        if (slotType == PSideConfigHelper.SlotType.OUTPUT) {
            return this.SLOTS_FOR_OUTPUT;
        }
        if (slotType == PSideConfigHelper.SlotType.IO) {
            return IntStream.concat(Arrays.stream(this.SLOTS_FOR_INPUT), Arrays.stream(this.SLOTS_FOR_OUTPUT)).toArray();
        }
        return new int[0];
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (Arrays.stream(INPUTSLOTS).anyMatch(s -> s == slot)) {
            RecipeHolder recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
            if (recipeHolder != null) {
                int inputIndex = IntStream.range(0, INPUTSLOTS.length).filter(i -> INPUTSLOTS[i] == slot).findFirst().orElse(-1);
                if (inputIndex >= 0 && inputIndex < this.SLOTS_FOR_OUTPUT.length) {
                    int outputSlot = this.SLOTS_FOR_OUTPUT[inputIndex];
                    ItemStack currentOutput = (ItemStack)this.items.get(outputSlot);
                    ItemStack resultStack = ((AbstractCookingRecipe)recipeHolder.value()).assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)this.level.registryAccess());
                    return currentOutput.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)currentOutput);
                }
                return false;
            }
            return false;
        }
        return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        PSideConfigHelper.SlotType slotType = this.pSideConfigHelper.getSlotType(direction);
        if (slotType == PSideConfigHelper.SlotType.INPUT || slotType == PSideConfigHelper.SlotType.IO) {
            return this.canPlaceItem(i, itemStack);
        }
        return false;
    }

    @Override
    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        PSideConfigHelper.SlotType slotType = this.pSideConfigHelper.getSlotType(direction);
        if (slotType != PSideConfigHelper.SlotType.OUTPUT && slotType != PSideConfigHelper.SlotType.IO) {
            return false;
        }
        return IntStream.of(this.SLOTS_FOR_OUTPUT).anyMatch(slot -> slot == i);
    }

    @Override
    protected void cycleSlotSideHelper(Direction side) {
        this.pSideConfigHelper.cycleSlotType(side);
    }

    @Override
    protected void cycleReversSlotSideHelper(Direction side) {
        this.pSideConfigHelper.cycleReversSlotType(side);
    }

    @Override
    protected void resetSlotSideHelper() {
        this.pSideConfigHelper.resetToDefault();
        this.setAutoExport(false);
        this.setChanged();
    }

    @Override
    protected void resetSlotTypeHelper(Direction side) {
        this.pSideConfigHelper.setSlotType(side, PSideConfigHelper.SlotType.NONE);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = this.worldPosition.relative(direction);
                this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite());
            }
        }
    }

    @Override
    protected void transferItemsOut(Direction direction, long currentTick) {
        BlockPos neighborPos;
        IItemHandler neighborInv;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        PSideConfigHelper.SlotType slotType = this.pSideConfigHelper.getSlotType(direction);
        if ((slotType == PSideConfigHelper.SlotType.OUTPUT || slotType == PSideConfigHelper.SlotType.IO) && (neighborInv = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, neighborPos = this.worldPosition.relative(direction), (Object)direction.getOpposite())) != null) {
            this.transferToItemHandler(neighborInv, true, currentTick);
        }
    }
}

