/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.compressedfurnace.entity.generator;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import net.biorfn.compressedfurnace.blocks.generator.GeneratorBlock;
import net.biorfn.compressedfurnace.config.Config;
import net.biorfn.compressedfurnace.energy.FEnergyStorage;
import net.biorfn.compressedfurnace.recipes.GeneratorRecipe;
import net.biorfn.compressedfurnace.registries.MultiFurnaceTieredItems;
import net.biorfn.compressedfurnace.util.entitiy.FuelManager;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public abstract class GeneratorBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
IEnergyStorage,
IFluidHandler {
    private static final int GENERATOR_FUEL_SLOT = 0;
    private int fuelBurnTime;
    private int burnDuration;
    protected String tierID;
    @javax.annotation.Nullable
    private static volatile Map<Item, Integer> fuelCache;
    private int lavaAmount = 0;
    protected final ContainerData dataAccess;
    public final FluidTank lavaTank;
    public NonNullList<ItemStack> items;
    private static Level level;
    private static boolean newRecipeAdded;
    private int initializationDelay = 10;
    public long lastGameTickEnergyUpdated;
    public final FEnergyStorage energyStorage;
    private static final RecipeType<? extends GeneratorRecipe> recipeType;
    private static final RecipeManager.CachedCheck<SingleRecipeInput, ? extends GeneratorRecipe> recipeCache;

    public GeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, String tierID) {
        super(type, pos, state);
        this.tierID = tierID;
        level = this.getLevel();
        this.energyStorage = this.createEnergyStorage(tierID);
        this.fuelBurnTime = 0;
        this.burnDuration = 0;
        this.items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        this.lavaTank = this.createLavaTank(tierID);
        this.dataAccess = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> GeneratorBlockEntity.this.fuelBurnTime;
                    case 1 -> GeneratorBlockEntity.this.burnDuration;
                    case 2 -> GeneratorBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> GeneratorBlockEntity.this.energyStorage.getMaxEnergyStored();
                    case 4 -> GeneratorBlockEntity.this.getLavaAmount();
                    case 5 -> GeneratorBlockEntity.this.lavaTank.getCapacity();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneratorBlockEntity.this.fuelBurnTime = value;
                        break;
                    }
                    case 1: {
                        GeneratorBlockEntity.this.burnDuration = value;
                        break;
                    }
                    case 2: {
                        GeneratorBlockEntity.this.energyStorage.setEnergy(value);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
            }

            public int getCount() {
                return 6;
            }
        };
    }

    public void setLevel(Level level1) {
        super.setLevel(level1);
        level = level1;
        GeneratorBlockEntity.validateFuelCache();
    }

    protected FluidTank createLavaTank(String tierID) {
        int capacity = switch (tierID) {
            case "compressed" -> (Integer)Config.compressedLavaTankCapacity.get();
            case "double_compressed" -> (Integer)Config.doubleCompressedLavaTankCapacity.get();
            case "triple_compressed" -> (Integer)Config.tripleCompressedLavaTankCapacity.get();
            default -> 0;
        };
        return new FluidTank(capacity, fluid -> fluid.is((Fluid)Fluids.LAVA)){

            protected void onContentsChanged() {
                GeneratorBlockEntity.this.setChanged();
            }
        };
    }

    protected FEnergyStorage createEnergyStorage(String tierID) {
        int capacity = switch (tierID) {
            case "compressed" -> (Integer)Config.compressedEnergyCapacity.get();
            case "double_compressed" -> (Integer)Config.doubleCompressedEnergyCapacity.get();
            case "triple_compressed" -> (Integer)Config.tripleCompressedEnergyCapacity.get();
            default -> 0;
        };
        int maxTransfer = switch (tierID) {
            case "compressed" -> (Integer)Config.compressedMaxTransferRate.get();
            case "double_compressed" -> (Integer)Config.doubleCompressedMaxTransferRate.get();
            case "triple_compressed" -> (Integer)Config.tripleCompressedMaxTransferRate.get();
            default -> 0;
        };
        return new FEnergyStorage(capacity, maxTransfer, maxTransfer, 0){

            @Override
            protected void onEnergyChanged() {
                if (level != null && level.getBlockEntity(GeneratorBlockEntity.this.getBlockPos()) != null) {
                    if (GeneratorBlockEntity.this.lastGameTickEnergyUpdated <= 0L) {
                        GeneratorBlockEntity.this.setChanged();
                        GeneratorBlockEntity.this.lastGameTickEnergyUpdated = level.getGameTime();
                    } else if (level.getGameTime() - GeneratorBlockEntity.this.lastGameTickEnergyUpdated >= 20L) {
                        GeneratorBlockEntity.this.setChanged();
                        GeneratorBlockEntity.this.lastGameTickEnergyUpdated = level.getGameTime();
                    }
                }
            }

            public boolean canReceive() {
                return false;
            }

            public boolean canExtract() {
                return true;
            }
        };
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.lavaTank.getFluid() : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.lavaTank.getCapacity() : 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && stack.getFluid() == Fluids.LAVA;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.lavaTank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.lavaTank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.lavaTank.drain(maxDrain, action);
    }

    private boolean isLit() {
        return this.fuelBurnTime > 0;
    }

    public static boolean isFuel(ItemStack stack) {
        return GeneratorBlockEntity.getFuel().containsKey(stack.getItem());
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> map = fuelCache;
        if (map != null && !newRecipeAdded) {
            return map;
        }
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        FuelManager.buildFuels((e, time) -> e.ifRight(tag -> FuelManager.add((Map<Item, Integer>)map1, (TagKey<Item>)tag, time)).ifLeft(item -> FuelManager.add((Map<Item, Integer>)map1, (ItemLike)item, time)));
        GeneratorBlockEntity.addCustomFuelRecipes((e, time) -> e.ifLeft(item -> GeneratorBlockEntity.addForCustomRecipe(map1, (ItemLike)item, time)));
        fuelCache = map1;
        newRecipeAdded = false;
        return map1;
    }

    public static void setNewRecipeFlag() {
        newRecipeAdded = true;
    }

    private static void addCustomFuelRecipes(ObjIntConsumer<Either<Item, TagKey<Item>>> map1) {
        if (SharedConstants.IS_RUNNING_IN_IDE && level != null) {
            GeneratorBlockEntity.processGeneratorRecipes(level, map1);
        }
    }

    private static void processGeneratorRecipes(Level level, ObjIntConsumer<Either<Item, TagKey<Item>>> map1) {
        RecipeManager recipeManager = level.getRecipeManager();
        List recipeList = recipeManager.getAllRecipesFor(recipeType);
        for (RecipeHolder recipeHolder : recipeList) {
            ItemStack[] itemStackArray = recipeHolder.value();
            if (!(itemStackArray instanceof GeneratorRecipe)) continue;
            GeneratorRecipe generatorRecipe = (GeneratorRecipe)itemStackArray;
            for (ItemStack ingredientStack : generatorRecipe.ingredient.getItems()) {
                if (ingredientStack.isEmpty()) continue;
                FuelManager.add(map1, (ItemLike)ingredientStack.getItem(), generatorRecipe.getEnergy());
            }
        }
    }

    private static void addForCustomRecipe(Map<Item, Integer> map, ItemLike itemLike, int burnTime) {
        Item item = itemLike.asItem();
        map.put(item, burnTime);
    }

    private static void validateFuelCache() {
        LinkedHashMap customFuelMap = Maps.newLinkedHashMap();
        GeneratorBlockEntity.addCustomFuelRecipes((e, time) -> e.ifLeft(item -> GeneratorBlockEntity.addForCustomRecipe(customFuelMap, (ItemLike)item, time)));
        if (fuelCache == null) {
            GeneratorBlockEntity.setNewRecipeFlag();
            return;
        }
        boolean cacheMismatch = false;
        for (Map.Entry entry : customFuelMap.entrySet()) {
            Item item = (Item)entry.getKey();
            int customBurnTime = (Integer)entry.getValue();
            if (fuelCache.containsKey(item) && fuelCache.get(item).equals(customBurnTime)) continue;
            cacheMismatch = true;
            break;
        }
        for (Item cacheItem : fuelCache.keySet()) {
            if (customFuelMap.containsKey(cacheItem)) continue;
            cacheMismatch = true;
            break;
        }
        if (cacheMismatch) {
            GeneratorBlockEntity.setNewRecipeFlag();
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GeneratorBlockEntity blockEntity) {
        if (!level.isClientSide) {
            boolean isLitNow;
            blockEntity.pullLavaFromAdjacent(pos, level);
            boolean wasLit = (Boolean)state.getValue((Property)GeneratorBlock.LIT);
            if (blockEntity.fuelBurnTime > 0) {
                blockEntity.burnFuel();
            } else {
                blockEntity.burnFuel();
                if (blockEntity.fuelBurnTime <= 0) {
                    blockEntity.burnLava();
                }
            }
            boolean bl = isLitNow = blockEntity.fuelBurnTime > 0;
            if (isLitNow != wasLit) {
                blockEntity.updateBlockStateWithLitFlag(level, pos, state, isLitNow);
            }
            if (blockEntity.hasEnergyToDistribute()) {
                blockEntity.distributeEnergy(level, pos);
            }
        }
    }

    private void updateBlockStateWithLitFlag(Level level, BlockPos pos, BlockState currentState, boolean lit) {
        if ((Boolean)currentState.getValue((Property)GeneratorBlock.LIT) != lit) {
            level.setBlock(pos, (BlockState)currentState.setValue((Property)GeneratorBlock.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        }
    }

    public int fillLavaTank(FluidStack resource, boolean simulate) {
        return this.lavaTank.fill(resource, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    protected void consumeLavaBucket() {
        int amountFilled;
        ItemStack fuel = this.getItem(0);
        if (fuel.getItem() == Items.LAVA_BUCKET && this.lavaTank.getFluidAmount() < this.lavaTank.getCapacity() && (amountFilled = this.fillLavaTank(new FluidStack((Fluid)Fluids.LAVA, 1000), false)) > 0) {
            this.setItem(0, new ItemStack((ItemLike)Items.BUCKET));
        }
    }

    protected void burnFuel() {
        this.consumeLavaBucket();
        if (this.fuelBurnTime > 0 && this.energyStorage.getEnergyStored() >= this.energyStorage.getMaxEnergyStored()) {
            return;
        }
        if (this.fuelBurnTime > 0) {
            --this.fuelBurnTime;
            int energyPerTick = this.getEnergyPerTick();
            this.energyStorage.setEnergy(Math.min(this.energyStorage.getCapacity(), this.energyStorage.getEnergyStored() + energyPerTick));
        } else {
            ItemStack fuel = this.getItem(0);
            if (!fuel.isEmpty()) {
                if (fuel.getItem() == Items.LAVA_BUCKET && this.lavaTank.getFluidAmount() == this.lavaTank.getCapacity()) {
                    double multiplier = this.getFuelMultiplier();
                    int adjustedBurnTime = (int)(20000.0 * multiplier);
                    this.startFuelBurning(fuel, adjustedBurnTime);
                    this.setItem(0, new ItemStack((ItemLike)Items.BUCKET));
                } else {
                    Integer burnTime = GeneratorBlockEntity.getFuel().get(fuel.getItem());
                    if (burnTime != null) {
                        this.startFuelBurning(fuel, burnTime);
                    }
                }
            } else {
                this.burnLava();
            }
        }
    }

    public FluidStack drainLavaTank(int maxDrain, boolean simulate) {
        return this.lavaTank.drain(maxDrain, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    private void burnLava() {
        int lavaToBurn = 100;
        if (this.fuelBurnTime <= 0 && this.lavaTank.getFluidAmount() >= lavaToBurn) {
            int burnTimePerLavaUnit = 2000;
            double modifier = this.getFuelMultiplier();
            int burnTime = (int)((double)burnTimePerLavaUnit * ((double)lavaToBurn / 1000.0) * modifier);
            this.drainLavaTank(lavaToBurn, false);
            this.startFuelBurning(new ItemStack((ItemLike)Items.LAVA_BUCKET), burnTime);
        }
    }

    private void startFuelBurning(ItemStack fuel, int burnTime) {
        fuel.shrink(1);
        double multiplier = this.getFuelMultiplier();
        this.burnDuration = this.fuelBurnTime = (int)((double)burnTime * multiplier);
    }

    public int getLavaAmount() {
        return this.lavaTank.getFluidAmount();
    }

    public int sendEnergy(int amount, IEnergyStorage destination) {
        int maxTransfer = this.energyStorage.getMaxExtract();
        int transferableAmount = Math.min(amount, maxTransfer);
        transferableAmount = Math.min(transferableAmount, this.energyStorage.getEnergyStored());
        int extracted = this.energyStorage.extractEnergy(transferableAmount, true);
        int accepted = destination.receiveEnergy(extracted, false);
        this.energyStorage.extractEnergy(accepted, false);
        return accepted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    private void distributeEnergy(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            IEnergyStorage targetStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite());
            if (targetStorage == null || !targetStorage.canReceive()) continue;
            int maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            int energyAccepted = targetStorage.receiveEnergy(maxTransfer, false);
            this.energyStorage.extractEnergy(energyAccepted, false);
            if (this.energyStorage.getEnergyStored() > 0) continue;
            return;
        }
    }

    public boolean hasEnergyToDistribute() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.tierID = tag.getString("TierID");
        this.fuelBurnTime = tag.getInt("FuelBurnTime");
        this.burnDuration = tag.getInt("BurnDuration");
        this.energyStorage.setEnergy(tag.getInt("Energy"));
        this.lavaAmount = tag.getInt("LavaAmount");
        this.initializationDelay = tag.getInt("InitializationDelay");
        this.lavaTank.readFromNBT(registries, tag.getCompound("LavaTank"));
        this.lastGameTickEnergyUpdated = 0L;
        this.dataAccess.set(0, this.fuelBurnTime);
        this.dataAccess.set(1, this.burnDuration);
        this.dataAccess.set(2, this.energyStorage.getEnergyStored());
        this.dataAccess.set(3, this.energyStorage.getMaxEnergyStored());
        this.dataAccess.set(4, this.lavaAmount);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("TierID", this.tierID);
        tag.putInt("FuelBurnTime", this.fuelBurnTime);
        tag.putInt("BurnDuration", this.burnDuration);
        tag.putInt("InitializationDelay", this.initializationDelay);
        tag.putInt("Energy", this.energyStorage.getEnergyStored());
        tag.putInt("Capacity", this.energyStorage.getMaxEnergyStored());
        tag.putInt("LavaAmount", this.lavaAmount);
        CompoundTag tankTag = new CompoundTag();
        this.lavaTank.writeToNBT(registries, tankTag);
        tag.put("LavaTank", (Tag)tankTag);
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return index == 0 && GeneratorBlockEntity.isFuel(itemStack) || itemStack.getItem() == Items.LAVA_BUCKET;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == 0 && stack.getItem() == Items.BUCKET;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourceLocation = recipe.id();
        }
    }

    @javax.annotation.Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void fillStackedContents(StackedContents stackedContents) {
        stackedContents.accountSimpleStack(this.getItem(0));
    }

    private void pullLavaFromAdjacent(BlockPos pos, Level level) {
        for (Direction direction : Direction.values()) {
            int spaceInTank;
            BlockPos adjacentPos = pos.relative(direction);
            BlockState adjacentState = level.getBlockState(adjacentPos);
            if (adjacentState.getBlock() != Blocks.LAVA_CAULDRON || (spaceInTank = this.lavaTank.getCapacity() - this.lavaTank.getFluidAmount()) < 1000) continue;
            level.setBlock(adjacentPos, Blocks.CAULDRON.defaultBlockState(), 3);
            this.lavaTank.fill(new FluidStack((Fluid)Fluids.LAVA, 1000), IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    protected int getEnergyPerTick() {
        if (this.fuelBurnTime > 0) {
            return switch (this.tierID) {
                case "compressed" -> (Integer)Config.compressedEnergyPerTick.get();
                case "double_compressed" -> (Integer)Config.doubleCompressedEnergyPerTick.get();
                case "triple_compressed" -> (Integer)Config.tripleCompressedEnergyPerTick.get();
                default -> 0;
            };
        }
        return 0;
    }

    protected double getFuelMultiplier() {
        return switch (this.tierID) {
            case "compressed" -> (Double)Config.compressedFuelMultiplier.get();
            case "double_compressed" -> (Double)Config.doubleCompressedFuelMultiplier.get();
            case "triple_compressed" -> (Double)Config.tripleCompressedFuelMultiplier.get();
            default -> 1.0;
        };
    }

    static {
        newRecipeAdded = false;
        recipeType = (RecipeType)MultiFurnaceTieredItems.GENERATOR_RECIPE_TYPE.get();
        recipeCache = RecipeManager.createCheck(recipeType);
    }
}

